/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.util.HashUtil;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALFactory;

public class ALContextKey {
    static final ALC alc = ALFactory.getALC();
    private final ALCcontext alCtx;
    private final long nativeAddress;
    private final int hashCodeValue;

    public ALContextKey(ALCcontext aLCcontext) {
        if (null == aLCcontext) {
            throw new IllegalArgumentException("null context");
        }
        this.alCtx = aLCcontext;
        if (null != this.alCtx) {
            this.nativeAddress = this.alCtx.getDirectBufferAddress();
            this.hashCodeValue = HashUtil.getAddrHash32_EqualDist((long)this.nativeAddress);
        } else {
            this.nativeAddress = 0L;
            this.hashCodeValue = 0;
        }
    }

    public ALCcontext getContext() {
        return this.alCtx;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ALContextKey)) {
            return false;
        }
        ALContextKey aLContextKey = (ALContextKey)object;
        return this.nativeAddress == aLContextKey.nativeAddress;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return "ALContextKey[alCtx hash 0x" + Integer.toHexString(System.identityHashCode(this.alCtx)) + ", native[ptr 0x" + Long.toHexString(this.nativeAddress) + ", hash 0x" + Integer.toHexString(this.hashCodeValue) + "]]";
    }
}

