/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.BootstrapConfig;
import io.netty.bootstrap.ChannelInitializerExtension;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private final BootstrapConfig config = new BootstrapConfig(this);
    private ExternalAddressResolver externalResolver;
    private volatile boolean disableResolver;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.externalResolver = bootstrap.externalResolver;
        this.disableResolver = bootstrap.disableResolver;
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public Bootstrap resolver(AddressResolverGroup<?> addressResolverGroup) {
        this.externalResolver = addressResolverGroup == null ? null : new ExternalAddressResolver(addressResolverGroup);
        this.disableResolver = false;
        return this;
    }

    public Bootstrap disableResolver() {
        this.externalResolver = null;
        this.disableResolver = true;
        return this;
    }

    public Bootstrap remoteAddress(SocketAddress socketAddress) {
        this.remoteAddress = socketAddress;
        return this;
    }

    public Bootstrap remoteAddress(String string, int n) {
        this.remoteAddress = InetSocketAddress.createUnresolved(string, n);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetAddress, int n) {
        this.remoteAddress = new InetSocketAddress(inetAddress, n);
        return this;
    }

    public ChannelFuture connect() {
        this.validate();
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(String string, int n) {
        return this.connect(InetSocketAddress.createUnresolved(string, n));
    }

    public ChannelFuture connect(InetAddress inetAddress, int n) {
        return this.connect(new InetSocketAddress(inetAddress, n));
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"remoteAddress");
        this.validate();
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"remoteAddress");
        this.validate();
        return this.doResolveAndConnect(socketAddress, socketAddress2);
    }

    private ChannelFuture doResolveAndConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2) {
        ChannelFuture channelFuture = this.initAndRegister();
        final Channel channel = channelFuture.channel();
        if (channelFuture.isDone()) {
            if (!channelFuture.isSuccess()) {
                return channelFuture;
            }
            return this.doResolveAndConnect0(channel, socketAddress, socketAddress2, channel.newPromise());
        }
        final AbstractBootstrap.PendingRegistrationPromise pendingRegistrationPromise = new AbstractBootstrap.PendingRegistrationPromise(channel);
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    pendingRegistrationPromise.setFailure(throwable);
                } else {
                    pendingRegistrationPromise.registered();
                    Bootstrap.this.doResolveAndConnect0(channel, socketAddress, socketAddress2, pendingRegistrationPromise);
                }
            }
        });
        return pendingRegistrationPromise;
    }

    private ChannelFuture doResolveAndConnect0(final Channel channel, SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        try {
            AddressResolver addressResolver;
            if (this.disableResolver) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            EventLoop eventLoop = channel.eventLoop();
            try {
                addressResolver = ExternalAddressResolver.getOrDefault(this.externalResolver).getResolver((EventExecutor)eventLoop);
            }
            catch (Throwable throwable) {
                channel.close();
                return channelPromise.setFailure(throwable);
            }
            if (!addressResolver.isSupported(socketAddress) || addressResolver.isResolved(socketAddress)) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            Future future = addressResolver.resolve(socketAddress);
            if (future.isDone()) {
                Throwable throwable = future.cause();
                if (throwable != null) {
                    channel.close();
                    channelPromise.setFailure(throwable);
                } else {
                    Bootstrap.doConnect((SocketAddress)future.getNow(), socketAddress2, channelPromise);
                }
                return channelPromise;
            }
            future.addListener((GenericFutureListener)new FutureListener<SocketAddress>(){

                public void operationComplete(Future<SocketAddress> future) {
                    if (future.cause() != null) {
                        channel.close();
                        channelPromise.setFailure(future.cause());
                    } else {
                        Bootstrap.doConnect((SocketAddress)future.getNow(), socketAddress2, channelPromise);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        return channelPromise;
    }

    private static void doConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        final Channel channel = channelPromise.channel();
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (socketAddress2 == null) {
                    channel.connect(socketAddress, channelPromise);
                } else {
                    channel.connect(socketAddress, socketAddress2, channelPromise);
                }
                channelPromise.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        });
    }

    @Override
    void init(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(this.config.handler());
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.newAttributesArray());
        Collection<ChannelInitializerExtension> collection = this.getInitializerExtensions();
        if (!collection.isEmpty()) {
            for (ChannelInitializerExtension channelInitializerExtension : collection) {
                try {
                    channelInitializerExtension.postInitializeClientChannel(channel);
                }
                catch (Exception exception) {
                    logger.warn("Exception thrown from postInitializeClientChannel", (Throwable)exception);
                }
            }
        }
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public Bootstrap clone(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap(this);
        bootstrap.group = eventLoopGroup;
        return bootstrap;
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        if (this.disableResolver) {
            return null;
        }
        return ExternalAddressResolver.getOrDefault(this.externalResolver);
    }

    static final class ExternalAddressResolver {
        final AddressResolverGroup<SocketAddress> resolverGroup;

        ExternalAddressResolver(AddressResolverGroup<?> addressResolverGroup) {
            this.resolverGroup = addressResolverGroup;
        }

        static AddressResolverGroup<SocketAddress> getOrDefault(ExternalAddressResolver externalAddressResolver) {
            if (externalAddressResolver == null) {
                DefaultAddressResolverGroup defaultAddressResolverGroup = DefaultAddressResolverGroup.INSTANCE;
                return defaultAddressResolverGroup;
            }
            return externalAddressResolver.resolverGroup;
        }
    }
}

