/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.StacklessClosedChannelException;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.channel.socket.ChannelOutputShutdownException;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private final Channel parent;
    private final ChannelId id;
    private final Channel.Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final CloseFuture closeFuture = new CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private boolean strValActive;
    private String strVal;

    protected AbstractChannel(Channel channel) {
        this.parent = channel;
        this.id = this.newId();
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected AbstractChannel(Channel channel, ChannelId channelId) {
        this.parent = channel;
        this.id = channelId;
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected final int maxMessagesPerWrite() {
        ChannelConfig channelConfig = this.config();
        if (channelConfig instanceof DefaultChannelConfig) {
            return ((DefaultChannelConfig)channelConfig).getMaxMessagesPerWrite();
        }
        Integer n = channelConfig.getOption(ChannelOption.MAX_MESSAGES_PER_WRITE);
        if (n == null) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public final ChannelId id() {
        return this.id;
    }

    protected ChannelId newId() {
        return DefaultChannelId.newInstance();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    @Override
    public boolean isWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null && channelOutboundBuffer.isWritable();
    }

    @Override
    public long bytesBeforeUnwritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null ? channelOutboundBuffer.bytesBeforeUnwritable() : 0L;
    }

    @Override
    public long bytesBeforeWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null ? channelOutboundBuffer.bytesBeforeWritable() : Long.MAX_VALUE;
    }

    @Override
    public Channel parent() {
        return this.parent;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress socketAddress = this.localAddress;
        if (socketAddress == null) {
            try {
                this.localAddress = socketAddress = this.unsafe().localAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateLocalAddress() {
        this.localAddress = null;
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            try {
                this.remoteAddress = socketAddress = this.unsafe().remoteAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateRemoteAddress() {
        this.remoteAddress = null;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline.bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline.connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline.connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    @Override
    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline.close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline.deregister(channelPromise);
    }

    @Override
    public Channel read() {
        this.pipeline.read();
        return this;
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.pipeline.write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline.write(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline.writeAndFlush(object);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline.writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline.newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline.newFailedFuture(throwable);
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        boolean bl = this.isActive();
        if (this.strValActive == bl && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress socketAddress = this.remoteAddress();
        SocketAddress socketAddress2 = this.localAddress();
        if (socketAddress != null) {
            StringBuilder stringBuilder = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(bl ? " - " : " ! ").append("R:").append(socketAddress).append(']');
            this.strVal = stringBuilder.toString();
        } else if (socketAddress2 != null) {
            StringBuilder stringBuilder = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(']');
            this.strVal = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = stringBuilder.toString();
        }
        this.strValActive = bl;
        return this.strVal;
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected void doRegister() {
    }

    protected abstract void doBind(SocketAddress var1);

    protected abstract void doDisconnect();

    protected abstract void doClose();

    protected void doShutdownOutput() {
        this.doClose();
    }

    protected void doDeregister() {
    }

    protected abstract void doBeginRead();

    protected abstract void doWrite(ChannelOutboundBuffer var1);

    protected Object filterOutboundMessage(Object object) {
        return object;
    }

    protected void validateFileRegion(DefaultFileRegion defaultFileRegion, long l) {
        DefaultFileRegion.validate(defaultFileRegion, l);
    }

    private static final class AnnotatedSocketException
    extends SocketException {
        private static final long serialVersionUID = 3896743275010454039L;

        AnnotatedSocketException(SocketException socketException, SocketAddress socketAddress) {
            super(socketException.getMessage() + ": " + socketAddress);
            this.initCause(socketException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedNoRouteToHostException
    extends NoRouteToHostException {
        private static final long serialVersionUID = -6801433937592080623L;

        AnnotatedNoRouteToHostException(NoRouteToHostException noRouteToHostException, SocketAddress socketAddress) {
            super(noRouteToHostException.getMessage() + ": " + socketAddress);
            this.initCause(noRouteToHostException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        private static final long serialVersionUID = 3901958112696433556L;

        AnnotatedConnectException(ConnectException connectException, SocketAddress socketAddress) {
            super(connectException.getMessage() + ": " + socketAddress);
            this.initCause(connectException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class CloseFuture
    extends DefaultChannelPromise {
        CloseFuture(AbstractChannel abstractChannel) {
            super(abstractChannel);
        }

        @Override
        public ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        @Override
        public ChannelPromise setFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        @Override
        public boolean trySuccess() {
            throw new IllegalStateException();
        }

        public boolean tryFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        boolean setClosed() {
            return super.trySuccess();
        }
    }

    protected abstract class AbstractUnsafe
    implements Channel.Unsafe {
        private volatile ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean inFlush0;
        private boolean neverRegistered;

        protected AbstractUnsafe() {
            this.outboundBuffer = new ChannelOutboundBuffer(AbstractChannel.this);
            this.neverRegistered = true;
        }

        private void assertEventLoop() {
            assert (!AbstractChannel.this.registered || AbstractChannel.this.eventLoop.inEventLoop());
        }

        @Override
        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = AbstractChannel.this.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        @Override
        public final ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }

        @Override
        public final SocketAddress localAddress() {
            return AbstractChannel.this.localAddress0();
        }

        @Override
        public final SocketAddress remoteAddress() {
            return AbstractChannel.this.remoteAddress0();
        }

        @Override
        public final void register(EventLoop eventLoop, final ChannelPromise channelPromise) {
            ObjectUtil.checkNotNull((Object)eventLoop, (String)"eventLoop");
            if (AbstractChannel.this.isRegistered()) {
                channelPromise.setFailure(new IllegalStateException("registered to an event loop already"));
                return;
            }
            if (!AbstractChannel.this.isCompatible(eventLoop)) {
                channelPromise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
                return;
            }
            AbstractChannel.this.eventLoop = eventLoop;
            if (eventLoop.inEventLoop()) {
                this.register0(channelPromise);
            } else {
                try {
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            AbstractUnsafe.this.register0(channelPromise);
                        }
                    });
                }
                catch (Throwable throwable) {
                    logger.warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)AbstractChannel.this, (Object)throwable);
                    this.closeForcibly();
                    AbstractChannel.this.closeFuture.setClosed();
                    this.safeSetFailure(channelPromise, throwable);
                }
            }
        }

        private void register0(ChannelPromise channelPromise) {
            try {
                if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                    return;
                }
                boolean bl = this.neverRegistered;
                AbstractChannel.this.doRegister();
                this.neverRegistered = false;
                AbstractChannel.this.registered = true;
                AbstractChannel.this.pipeline.invokeHandlerAddedIfNeeded();
                this.safeSetSuccess(channelPromise);
                AbstractChannel.this.pipeline.fireChannelRegistered();
                if (AbstractChannel.this.isActive()) {
                    if (bl) {
                        AbstractChannel.this.pipeline.fireChannelActive();
                    } else if (AbstractChannel.this.config().isAutoRead()) {
                        this.beginRead();
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeForcibly();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
            }
        }

        @Override
        public final void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
            this.assertEventLoop();
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            if (Boolean.TRUE.equals(AbstractChannel.this.config().getOption(ChannelOption.SO_BROADCAST)) && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.maybeSuperUser()) {
                logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + socketAddress + ") anyway as requested.");
            }
            boolean bl = AbstractChannel.this.isActive();
            try {
                AbstractChannel.this.doBind(socketAddress);
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                this.closeIfClosed();
                return;
            }
            if (!bl && AbstractChannel.this.isActive()) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireChannelActive();
                    }
                });
            }
            this.safeSetSuccess(channelPromise);
        }

        @Override
        public final void disconnect(ChannelPromise channelPromise) {
            this.assertEventLoop();
            if (!channelPromise.setUncancellable()) {
                return;
            }
            boolean bl = AbstractChannel.this.isActive();
            try {
                AbstractChannel.this.doDisconnect();
                AbstractChannel.this.remoteAddress = null;
                AbstractChannel.this.localAddress = null;
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                this.closeIfClosed();
                return;
            }
            if (bl && !AbstractChannel.this.isActive()) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireChannelInactive();
                    }
                });
            }
            this.safeSetSuccess(channelPromise);
            this.closeIfClosed();
        }

        @Override
        public void close(ChannelPromise channelPromise) {
            this.assertEventLoop();
            StacklessClosedChannelException stacklessClosedChannelException = StacklessClosedChannelException.newInstance(AbstractChannel.class, "close(ChannelPromise)");
            this.close(channelPromise, stacklessClosedChannelException, stacklessClosedChannelException, false);
        }

        public final void shutdownOutput(ChannelPromise channelPromise) {
            this.assertEventLoop();
            this.shutdownOutput(channelPromise, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdownOutput(ChannelPromise channelPromise, Throwable throwable) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                channelPromise.setFailure(new ClosedChannelException());
                return;
            }
            this.outboundBuffer = null;
            ChannelOutputShutdownException channelOutputShutdownException = throwable == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", throwable);
            try {
                AbstractChannel.this.doShutdownOutput();
                channelPromise.setSuccess();
            }
            catch (Throwable throwable2) {
                channelPromise.setFailure(throwable2);
            }
            finally {
                this.closeOutboundBufferForShutdown(AbstractChannel.this.pipeline, channelOutboundBuffer, channelOutputShutdownException);
            }
        }

        private void closeOutboundBufferForShutdown(ChannelPipeline channelPipeline, ChannelOutboundBuffer channelOutboundBuffer, Throwable throwable) {
            channelOutboundBuffer.failFlushed(throwable, false);
            channelOutboundBuffer.close(throwable, true);
            channelPipeline.fireUserEventTriggered(ChannelOutputShutdownEvent.INSTANCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(final ChannelPromise channelPromise, final Throwable throwable, final ClosedChannelException closedChannelException, final boolean bl) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (AbstractChannel.this.closeInitiated) {
                if (AbstractChannel.this.closeFuture.isDone()) {
                    this.safeSetSuccess(channelPromise);
                } else if (!(channelPromise instanceof VoidChannelPromise)) {
                    AbstractChannel.this.closeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            channelPromise.setSuccess();
                        }
                    });
                }
                return;
            }
            AbstractChannel.this.closeInitiated = true;
            final boolean bl2 = AbstractChannel.this.isActive();
            final ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            this.outboundBuffer = null;
            Executor executor = this.prepareToClose();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractUnsafe.this.doClose0(channelPromise);
                        }
                        catch (Throwable throwable2) {
                            AbstractUnsafe.this.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (channelOutboundBuffer != null) {
                                        channelOutboundBuffer.failFlushed(throwable, bl);
                                        channelOutboundBuffer.close(closedChannelException);
                                    }
                                    AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                                }
                            });
                            throw throwable2;
                        }
                        AbstractUnsafe.this.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            } else {
                try {
                    this.doClose0(channelPromise);
                }
                finally {
                    if (channelOutboundBuffer != null) {
                        channelOutboundBuffer.failFlushed(throwable, bl);
                        channelOutboundBuffer.close(closedChannelException);
                    }
                }
                if (this.inFlush0) {
                    this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                        }
                    });
                } else {
                    this.fireChannelInactiveAndDeregister(bl2);
                }
            }
        }

        private void doClose0(ChannelPromise channelPromise) {
            try {
                AbstractChannel.this.doClose();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetSuccess(channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
            }
        }

        private void fireChannelInactiveAndDeregister(boolean bl) {
            this.deregister(this.voidPromise(), bl && !AbstractChannel.this.isActive());
        }

        @Override
        public final void closeForcibly() {
            this.assertEventLoop();
            try {
                AbstractChannel.this.doClose();
            }
            catch (Exception exception) {
                logger.warn("Failed to close a channel.", (Throwable)exception);
            }
        }

        @Override
        public final void deregister(ChannelPromise channelPromise) {
            this.assertEventLoop();
            this.deregister(channelPromise, false);
        }

        private void deregister(final ChannelPromise channelPromise, final boolean bl) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (!AbstractChannel.this.registered) {
                this.safeSetSuccess(channelPromise);
                return;
            }
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractChannel.this.doDeregister();
                    }
                    catch (Throwable throwable) {
                        logger.warn("Unexpected exception occurred while deregistering a channel.", throwable);
                    }
                    finally {
                        if (bl) {
                            AbstractChannel.this.pipeline.fireChannelInactive();
                        }
                        if (AbstractChannel.this.registered) {
                            AbstractChannel.this.registered = false;
                            AbstractChannel.this.pipeline.fireChannelUnregistered();
                        }
                        AbstractUnsafe.this.safeSetSuccess(channelPromise);
                    }
                }
            });
        }

        @Override
        public final void beginRead() {
            this.assertEventLoop();
            try {
                AbstractChannel.this.doBeginRead();
            }
            catch (Exception exception) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireExceptionCaught(exception);
                    }
                });
                this.close(this.voidPromise());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void write(Object object, ChannelPromise channelPromise) {
            int n;
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                try {
                    ReferenceCountUtil.release((Object)object);
                }
                finally {
                    this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "write(Object, ChannelPromise)"));
                }
                return;
            }
            try {
                object = AbstractChannel.this.filterOutboundMessage(object);
                n = AbstractChannel.this.pipeline.estimatorHandle().size(object);
                if (n < 0) {
                    n = 0;
                }
            }
            catch (Throwable throwable) {
                try {
                    ReferenceCountUtil.release((Object)object);
                }
                finally {
                    this.safeSetFailure(channelPromise, throwable);
                }
                return;
            }
            channelOutboundBuffer.addMessage(object, n, channelPromise);
        }

        @Override
        public final void flush() {
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                return;
            }
            channelOutboundBuffer.addFlush();
            this.flush0();
        }

        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null || channelOutboundBuffer.isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!AbstractChannel.this.isActive()) {
                try {
                    if (!channelOutboundBuffer.isEmpty()) {
                        if (AbstractChannel.this.isOpen()) {
                            channelOutboundBuffer.failFlushed(new NotYetConnectedException(), true);
                        } else {
                            channelOutboundBuffer.failFlushed(this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "flush0()"), false);
                        }
                    }
                }
                finally {
                    this.inFlush0 = false;
                }
                return;
            }
            try {
                AbstractChannel.this.doWrite(channelOutboundBuffer);
            }
            catch (Throwable throwable) {
                this.handleWriteError(throwable);
            }
            finally {
                this.inFlush0 = false;
            }
        }

        protected final void handleWriteError(Throwable throwable) {
            if (throwable instanceof IOException && AbstractChannel.this.config().isAutoClose()) {
                AbstractChannel.this.initialCloseCause = throwable;
                this.close(this.voidPromise(), throwable, this.newClosedChannelException(throwable, "flush0()"), false);
            } else {
                try {
                    this.shutdownOutput(this.voidPromise(), throwable);
                }
                catch (Throwable throwable2) {
                    AbstractChannel.this.initialCloseCause = throwable;
                    this.close(this.voidPromise(), throwable2, this.newClosedChannelException(throwable, "flush0()"), false);
                }
            }
        }

        private ClosedChannelException newClosedChannelException(Throwable throwable, String string) {
            StacklessClosedChannelException stacklessClosedChannelException = StacklessClosedChannelException.newInstance(AbstractUnsafe.class, string);
            if (throwable != null) {
                stacklessClosedChannelException.initCause(throwable);
            }
            return stacklessClosedChannelException;
        }

        @Override
        public final ChannelPromise voidPromise() {
            this.assertEventLoop();
            return AbstractChannel.this.unsafeVoidPromise;
        }

        protected final boolean ensureOpen(ChannelPromise channelPromise) {
            if (AbstractChannel.this.isOpen()) {
                return true;
            }
            this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "ensureOpen(ChannelPromise)"));
            return false;
        }

        protected final void safeSetSuccess(ChannelPromise channelPromise) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
            }
        }

        protected final void safeSetFailure(ChannelPromise channelPromise, Throwable throwable) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
                logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
            }
        }

        protected final void closeIfClosed() {
            if (AbstractChannel.this.isOpen()) {
                return;
            }
            this.close(this.voidPromise());
        }

        private void invokeLater(Runnable runnable) {
            try {
                AbstractChannel.this.eventLoop().execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)rejectedExecutionException);
            }
        }

        protected final Throwable annotateConnectException(Throwable throwable, SocketAddress socketAddress) {
            if (throwable instanceof ConnectException) {
                return new AnnotatedConnectException((ConnectException)throwable, socketAddress);
            }
            if (throwable instanceof NoRouteToHostException) {
                return new AnnotatedNoRouteToHostException((NoRouteToHostException)throwable, socketAddress);
            }
            if (throwable instanceof SocketException) {
                return new AnnotatedSocketException((SocketException)throwable, socketAddress);
            }
            return throwable;
        }

        protected Executor prepareToClose() {
            return null;
        }
    }
}

