/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.DuplexChannelConfig;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Map;

public final class NioDomainSocketChannel
extends AbstractNioByteChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDomainSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final ChannelConfig config;
    private volatile boolean isInputShutdown;
    private volatile boolean isOutputShutdown;

    static SocketChannel newChannel(SelectorProvider selectorProvider) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        try {
            SocketChannel socketChannel = (SocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider);
            if (socketChannel == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return socketChannel;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioDomainSocketChannel(SelectorProvider selectorProvider) {
        this(NioDomainSocketChannel.newChannel(selectorProvider));
    }

    public NioDomainSocketChannel(SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioDomainSocketChannel(Channel channel, SocketChannel socketChannel) {
        super(channel, socketChannel);
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        this.config = new NioDomainSocketChannelConfig(this, socketChannel);
    }

    @Override
    public ServerChannel parent() {
        return (ServerChannel)super.parent();
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    protected SocketChannel javaChannel() {
        return (SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.isOutputShutdown || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.isInputShutdown || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        return this.isInputShutdown() && this.isOutputShutdown() || !this.isActive();
    }

    @Override
    protected void doShutdownOutput() {
        this.javaChannel().shutdownOutput();
        this.isOutputShutdown = true;
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)((Object)NioDomainSocketChannel.this.unsafe())).shutdownOutput(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    NioDomainSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    NioDomainSocketChannel.this.shutdownOutputDone(channelFuture, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutputDone(final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            NioDomainSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture2) {
                    NioDomainSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownInput0() {
        this.javaChannel().shutdownInput();
        this.isInputShutdown = true;
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected SocketAddress remoteAddress0() {
        try {
            return this.javaChannel().getRemoteAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        SocketUtils.bind((SocketChannel)this.javaChannel(), (SocketAddress)socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = SocketUtils.connect((SocketChannel)this.javaChannel(), (SocketAddress)socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        try {
            super.doClose();
        }
        finally {
            this.javaChannel().close();
        }
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) {
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), handle.attemptedBytesRead());
    }

    @Override
    protected int doWriteBytes(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        return byteBuf.readBytes((GatheringByteChannel)this.javaChannel(), n);
    }

    @Override
    protected long doWriteFileRegion(FileRegion fileRegion) {
        long l = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l);
    }

    private void adjustMaxBytesPerGatheringWrite(int n, int n2, int n3) {
        if (n == n2) {
            if (n << 1 > n3) {
                ((NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n << 1);
            }
        } else if (n > 4096 && n2 < n >>> 1) {
            ((NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n >>> 1);
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        SocketChannel socketChannel = this.javaChannel();
        int n = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n2 = ((NioDomainSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n2);
            int n3 = channelOutboundBuffer.nioBufferCount();
            switch (n3) {
                case 0: {
                    n -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n4 = byteBuffer.remaining();
                    int n5 = socketChannel.write(byteBuffer);
                    if (n5 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n4, n5, n2);
                    channelOutboundBuffer.removeBytes(n5);
                    --n;
                    break;
                }
                default: {
                    long l = channelOutboundBuffer.nioBufferSize();
                    long l2 = socketChannel.write(byteBufferArray, 0, n3);
                    if (l2 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l, (int)l2, n2);
                    channelOutboundBuffer.removeBytes(l2);
                    --n;
                    break;
                }
            }
        } while (n > 0);
        this.incompleteWrite(n < 0);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    private final class NioDomainSocketChannelConfig
    extends DefaultChannelConfig
    implements DuplexChannelConfig {
        private volatile boolean allowHalfClosure;
        private volatile int maxBytesPerGatheringWrite;
        private final SocketChannel javaChannel;

        private NioDomainSocketChannelConfig(NioDomainSocketChannel nioDomainSocketChannel2, SocketChannel socketChannel) {
            super(nioDomainSocketChannel2);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.javaChannel = socketChannel;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        public boolean isAllowHalfClosure() {
            return this.allowHalfClosure;
        }

        @Override
        public NioDomainSocketChannelConfig setAllowHalfClosure(boolean bl) {
            this.allowHalfClosure = bl;
            return this;
        }

        @Override
        public Map<ChannelOption<?>, Object> getOptions() {
            ArrayList<ChannelOption> arrayList = new ArrayList<ChannelOption>();
            arrayList.add(ChannelOption.SO_RCVBUF);
            arrayList.add(ChannelOption.SO_SNDBUF);
            for (ChannelOption channelOption : NioChannelOption.getOptions(this.jdkChannel())) {
                arrayList.add(channelOption);
            }
            return this.getOptions(super.getOptions(), arrayList.toArray(new ChannelOption[0]));
        }

        @Override
        public <T> T getOption(ChannelOption<T> channelOption) {
            if (channelOption == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (channelOption == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (channelOption instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
            }
            return super.getOption(channelOption);
        }

        @Override
        public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
            if (channelOption == ChannelOption.SO_RCVBUF) {
                this.validate(channelOption, t);
                this.setReceiveBufferSize((Integer)t);
            } else if (channelOption == ChannelOption.SO_SNDBUF) {
                this.validate(channelOption, t);
                this.setSendBufferSize((Integer)t);
            } else {
                if (channelOption instanceof NioChannelOption) {
                    return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t);
                }
                return super.setOption(channelOption, t);
            }
            return true;
        }

        private int getReceiveBufferSize() {
            try {
                return this.javaChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }

        private NioDomainSocketChannelConfig setReceiveBufferSize(int n) {
            try {
                this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
            return this;
        }

        private int getSendBufferSize() {
            try {
                return this.javaChannel.getOption(StandardSocketOptions.SO_SNDBUF);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }

        private NioDomainSocketChannelConfig setSendBufferSize(int n) {
            try {
                this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)n);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setConnectTimeoutMillis(int n) {
            super.setConnectTimeoutMillis(n);
            return this;
        }

        @Override
        @Deprecated
        public NioDomainSocketChannelConfig setMaxMessagesPerRead(int n) {
            super.setMaxMessagesPerRead(n);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setWriteSpinCount(int n) {
            super.setWriteSpinCount(n);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
            super.setAllocator(byteBufAllocator);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
            super.setRecvByteBufAllocator(recvByteBufAllocator);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setAutoRead(boolean bl) {
            super.setAutoRead(bl);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setAutoClose(boolean bl) {
            super.setAutoClose(bl);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setWriteBufferHighWaterMark(int n) {
            super.setWriteBufferHighWaterMark(n);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setWriteBufferLowWaterMark(int n) {
            super.setWriteBufferLowWaterMark(n);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
            super.setWriteBufferWaterMark(writeBufferWaterMark);
            return this;
        }

        @Override
        public NioDomainSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
            super.setMessageSizeEstimator(messageSizeEstimator);
            return this;
        }

        @Override
        protected void autoReadCleared() {
            NioDomainSocketChannel.this.clearReadPending();
        }

        void setMaxBytesPerGatheringWrite(int n) {
            this.maxBytesPerGatheringWrite = n;
        }

        int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        private void calculateMaxBytesPerGatheringWrite() {
            int n = this.getSendBufferSize() << 1;
            if (n > 0) {
                this.setMaxBytesPerGatheringWrite(n);
            }
        }

        private SocketChannel jdkChannel() {
            return this.javaChannel;
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
        }
    }
}

