/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecImpl;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.FloatExponentialDecaySpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001aI\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\b\b\u0001\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00012\u0006\u0010\b\u001a\u0002H\u0001\u00a2\u0006\u0002\u0010\t\u001a \u0010\u0000\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\n\u001a&\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\u0004\b\u0000\u0010\u00012\b\b\u0003\u0010\f\u001a\u00020\n2\b\b\u0003\u0010\r\u001a\u00020\n\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\u0004\b\u0000\u0010\u0001*\u00020\u000f\u00a8\u0006\u0010"}, d2={"calculateTargetValue", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/DecayAnimationSpec;", "typeConverter", "Landroidx/compose/animation/core/TwoWayConverter;", "initialValue", "initialVelocity", "(Landroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "exponentialDecay", "frictionMultiplier", "absVelocityThreshold", "generateDecayAnimationSpec", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "animation-core"})
public final class DecayAnimationSpecKt {
    public static final <T, V extends AnimationVector> T calculateTargetValue(DecayAnimationSpec<T> decayAnimationSpec, TwoWayConverter<T, V> twoWayConverter, T t, T t2) {
        Intrinsics.checkNotNullParameter(decayAnimationSpec, (String)"");
        Intrinsics.checkNotNullParameter(twoWayConverter, (String)"");
        VectorizedDecayAnimationSpec<AnimationVector> vectorizedDecayAnimationSpec = decayAnimationSpec.vectorize(twoWayConverter);
        AnimationVector animationVector = vectorizedDecayAnimationSpec.getTargetValue((AnimationVector)twoWayConverter.getConvertToVector().invoke(t), (AnimationVector)twoWayConverter.getConvertToVector().invoke(t2));
        return (T)twoWayConverter.getConvertFromVector().invoke((Object)animationVector);
    }

    public static final float calculateTargetValue(DecayAnimationSpec<Float> decayAnimationSpec, float f, float f2) {
        Intrinsics.checkNotNullParameter(decayAnimationSpec, (String)"");
        VectorizedDecayAnimationSpec<AnimationVector1D> vectorizedDecayAnimationSpec = decayAnimationSpec.vectorize(VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE));
        AnimationVector1D animationVector1D = vectorizedDecayAnimationSpec.getTargetValue((AnimationVector1D)((AnimationVector)AnimationVectorsKt.AnimationVector(f)), (AnimationVector1D)((AnimationVector)AnimationVectorsKt.AnimationVector(f2)));
        return animationVector1D.getValue();
    }

    public static final <T> DecayAnimationSpec<T> exponentialDecay(float f, float f2) {
        return DecayAnimationSpecKt.generateDecayAnimationSpec(new FloatExponentialDecaySpec(f, f2));
    }

    public static /* synthetic */ DecayAnimationSpec exponentialDecay$default(float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        return DecayAnimationSpecKt.exponentialDecay(f, f2);
    }

    public static final <T> DecayAnimationSpec<T> generateDecayAnimationSpec(FloatDecayAnimationSpec floatDecayAnimationSpec) {
        Intrinsics.checkNotNullParameter((Object)floatDecayAnimationSpec, (String)"");
        return new DecayAnimationSpecImpl(floatDecayAnimationSpec);
    }
}

