/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

class UnpooledUnsafeNoCleanerDirectByteBuf
extends UnpooledUnsafeDirectByteBuf {
    UnpooledUnsafeNoCleanerDirectByteBuf(ByteBufAllocator byteBufAllocator, int n, int n2) {
        super(byteBufAllocator, n, n2);
    }

    @Override
    protected ByteBuffer allocateDirect(int n) {
        return PlatformDependent.allocateDirectNoCleaner((int)n);
    }

    ByteBuffer reallocateDirect(ByteBuffer byteBuffer, int n) {
        return PlatformDependent.reallocateDirectNoCleaner((ByteBuffer)byteBuffer, (int)n);
    }

    @Override
    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectNoCleaner((ByteBuffer)byteBuffer);
    }

    @Override
    public ByteBuf capacity(int n) {
        this.checkNewCapacity(n);
        int n2 = this.capacity();
        if (n == n2) {
            return this;
        }
        this.trimIndicesToCapacity(n);
        this.setByteBuffer(this.reallocateDirect(this.buffer, n), false);
        return this;
    }
}

