/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.unix;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;

public class LibCUtil {
    private static final NativeLibrary LIBC = NativeLibrary.getInstance((String)"c");
    private static Function mmap = null;
    private static boolean mmap64 = false;
    private static Function ftruncate = null;
    private static boolean ftruncate64 = false;

    private LibCUtil() {
    }

    public static Pointer mmap(Pointer pointer, long l, int n, int n2, int n3, long l2) {
        Object[] objectArray = new Object[6];
        objectArray[0] = pointer;
        if (Native.SIZE_T_SIZE == 4) {
            LibCUtil.require32Bit(l, "length");
            objectArray[1] = (int)l;
        } else {
            objectArray[1] = l;
        }
        objectArray[2] = n;
        objectArray[3] = n2;
        objectArray[4] = n3;
        if (mmap64 || Native.LONG_SIZE > 4) {
            objectArray[5] = l2;
        } else {
            LibCUtil.require32Bit(l2, "offset");
            objectArray[5] = (int)l2;
        }
        return mmap.invokePointer(objectArray);
    }

    public static int ftruncate(int n, long l) {
        Object[] objectArray = new Object[2];
        objectArray[0] = n;
        if (ftruncate64 || Native.LONG_SIZE > 4) {
            objectArray[1] = l;
        } else {
            LibCUtil.require32Bit(l, "length");
            objectArray[1] = (int)l;
        }
        return ftruncate.invokeInt(objectArray);
    }

    public static void require32Bit(long l, String string) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + " exceeds 32bit");
        }
    }

    static {
        try {
            mmap = LIBC.getFunction("mmap64", 64);
            mmap64 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mmap = LIBC.getFunction("mmap", 64);
        }
        try {
            ftruncate = LIBC.getFunction("ftruncate64", 64);
            ftruncate64 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            ftruncate = LIBC.getFunction("ftruncate", 64);
        }
    }
}

