/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.List;

public abstract class PdhUtil {
    private static final int CHAR_TO_BYTES = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
    private static final String ENGLISH_COUNTER_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009";
    private static final String ENGLISH_COUNTER_VALUE = "Counter";

    public static String PdhLookupPerfNameByIndex(String string, int n) {
        WinDef.DWORDByReference dWORDByReference = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        int n2 = Pdh.INSTANCE.PdhLookupPerfNameByIndex(string, n, null, dWORDByReference);
        Memory memory = null;
        if (n2 != -1073738819) {
            if (n2 != 0 && n2 != -2147481646) {
                throw new PdhException(n2);
            }
            if (dWORDByReference.getValue().intValue() < 1) {
                return "";
            }
            memory = new Memory((long)(dWORDByReference.getValue().intValue() * CHAR_TO_BYTES));
            n2 = Pdh.INSTANCE.PdhLookupPerfNameByIndex(string, n, (Pointer)memory, dWORDByReference);
        } else {
            for (int i = 32; i <= 1024 && ((n2 = Pdh.INSTANCE.PdhLookupPerfNameByIndex(string, n, (Pointer)(memory = new Memory((long)(i * CHAR_TO_BYTES))), dWORDByReference = new WinDef.DWORDByReference(new WinDef.DWORD(i)))) == -1073738819 || n2 == -1073738814); i *= 2) {
            }
        }
        if (n2 != 0) {
            throw new PdhException(n2);
        }
        if (CHAR_TO_BYTES == 1) {
            return memory.getString(0L);
        }
        return memory.getWideString(0L);
    }

    public static int PdhLookupPerfIndexByEnglishName(String string) {
        String[] stringArray = Advapi32Util.registryGetStringArray(WinReg.HKEY_LOCAL_MACHINE, ENGLISH_COUNTER_KEY, ENGLISH_COUNTER_VALUE);
        for (int i = 1; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            try {
                return Integer.parseInt(stringArray[i - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public static PdhEnumObjectItems PdhEnumObjectItems(String string, String string2, String string3, int n) {
        String string4;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        WinDef.DWORDByReference dWORDByReference = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference dWORDByReference2 = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        int n2 = Pdh.INSTANCE.PdhEnumObjectItems(string, string2, string3, null, dWORDByReference, null, dWORDByReference2, n, 0);
        if (n2 != 0 && n2 != -2147481646) {
            throw new PdhException(n2);
        }
        Memory memory = null;
        Memory memory2 = null;
        do {
            long l;
            if (dWORDByReference.getValue().intValue() > 0) {
                memory = new Memory((long)(dWORDByReference.getValue().intValue() * CHAR_TO_BYTES));
            }
            if (dWORDByReference2.getValue().intValue() > 0) {
                memory2 = new Memory((long)(dWORDByReference2.getValue().intValue() * CHAR_TO_BYTES));
            }
            if ((n2 = Pdh.INSTANCE.PdhEnumObjectItems(string, string2, string3, (Pointer)memory, dWORDByReference, (Pointer)memory2, dWORDByReference2, n, 0)) != -2147481646) continue;
            if (memory != null) {
                l = memory.size() / (long)CHAR_TO_BYTES;
                dWORDByReference.setValue(new WinDef.DWORD(l + 1024L));
                memory.close();
            }
            if (memory2 == null) continue;
            l = memory2.size() / (long)CHAR_TO_BYTES;
            dWORDByReference2.setValue(new WinDef.DWORD(l + 1024L));
            memory2.close();
        } while (n2 == -2147481646);
        if (n2 != 0) {
            throw new PdhException(n2);
        }
        if (memory != null) {
            int n3 = 0;
            while ((long)n3 < memory.size()) {
                string4 = null;
                string4 = CHAR_TO_BYTES == 1 ? memory.getString((long)n3) : memory.getWideString((long)n3);
                if (string4.isEmpty()) break;
                arrayList.add(string4);
                n3 += (string4.length() + 1) * CHAR_TO_BYTES;
            }
        }
        if (memory2 != null) {
            int n4 = 0;
            while ((long)n4 < memory2.size()) {
                string4 = null;
                string4 = CHAR_TO_BYTES == 1 ? memory2.getString((long)n4) : memory2.getWideString((long)n4);
                if (string4.isEmpty()) break;
                arrayList2.add(string4);
                n4 += (string4.length() + 1) * CHAR_TO_BYTES;
            }
        }
        return new PdhEnumObjectItems(arrayList, arrayList2);
    }

    public static final class PdhException
    extends RuntimeException {
        private final int errorCode;

        public PdhException(int n) {
            super(String.format("Pdh call failed with error code 0x%08X", n));
            this.errorCode = n;
        }

        public int getErrorCode() {
            return this.errorCode;
        }
    }

    public static class PdhEnumObjectItems {
        private final List<String> counters;
        private final List<String> instances;

        public PdhEnumObjectItems(List<String> list, List<String> list2) {
            this.counters = this.copyAndEmptyListForNullList(list);
            this.instances = this.copyAndEmptyListForNullList(list2);
        }

        public List<String> getCounters() {
            return this.counters;
        }

        public List<String> getInstances() {
            return this.instances;
        }

        private List<String> copyAndEmptyListForNullList(List<String> list) {
            if (list == null) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(list);
        }

        public String toString() {
            return "PdhEnumObjectItems{counters=" + this.counters + ", instances=" + this.instances + '}';
        }
    }
}

