/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.util.internal.ObjectUtil;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public final class OpenSslCachingX509KeyManagerFactory
extends KeyManagerFactory {
    private final int maxCachedEntries;

    public OpenSslCachingX509KeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this(keyManagerFactory, 1024);
    }

    public OpenSslCachingX509KeyManagerFactory(final KeyManagerFactory keyManagerFactory, int n) {
        super(new KeyManagerFactorySpi(){

            @Override
            protected void engineInit(KeyStore keyStore, char[] cArray) {
                keyManagerFactory.init(keyStore, cArray);
            }

            @Override
            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
                keyManagerFactory.init(managerFactoryParameters);
            }

            @Override
            protected KeyManager[] engineGetKeyManagers() {
                return keyManagerFactory.getKeyManagers();
            }
        }, keyManagerFactory.getProvider(), keyManagerFactory.getAlgorithm());
        this.maxCachedEntries = ObjectUtil.checkPositive((int)n, (String)"maxCachedEntries");
    }

    OpenSslKeyMaterialProvider newProvider(String string) {
        X509KeyManager x509KeyManager = ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers());
        if ("sun.security.ssl.X509KeyManagerImpl".equals(x509KeyManager.getClass().getName())) {
            return new OpenSslKeyMaterialProvider(x509KeyManager, string);
        }
        return new OpenSslCachingKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers()), string, this.maxCachedEntries);
    }
}

