/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import io.netty.handler.ssl.GroupsConverter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslCertificateCompressionAlgorithm;
import io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import io.netty.internal.tcnative.CertificateCompressionAlgo;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.ResultCallback;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SSLPrivateKeyMethod;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", (int)2048));
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.useTasks", (boolean)true);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    static final boolean CLIENT_ENABLE_SESSION_TICKET;
    static final boolean CLIENT_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_TICKET;
    static final boolean SERVER_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_CACHE;
    static final boolean CLIENT_ENABLE_SESSION_CACHE;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                ReferenceCountedOpenSslContext.this.leak.record(object);
            }
            return ReferenceCountedOpenSslContext.this;
        }

        protected void deallocate() {
            ReferenceCountedOpenSslContext.this.destroy();
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                boolean bl = ReferenceCountedOpenSslContext.this.leak.close((Object)ReferenceCountedOpenSslContext.this);
                assert (bl);
            }
        }
    };
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final String endpointIdentificationAlgorithm;
    final boolean hasTLSv13Cipher;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;
    final boolean tlsFalseStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, int n, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl, String string, boolean bl2, boolean bl3, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        super(bl, resumptionController);
        Serializable serializable;
        OpenSsl.ensureAvailability();
        if (bl2 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        boolean bl4 = false;
        boolean bl5 = USE_TASKS;
        OpenSslPrivateKeyMethod openSslPrivateKeyMethod = null;
        OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod = null;
        OpenSslCertificateCompressionConfig openSslCertificateCompressionConfig = null;
        Integer n2 = null;
        Object[] objectArray = OpenSsl.NAMED_GROUPS;
        if (entryArray != null) {
            for (Map.Entry<SslContextOption<?>, Object> entry : entryArray) {
                SslContextOption<?> sslContextOption = entry.getKey();
                if (sslContextOption == OpenSslContextOption.TLS_FALSE_START) {
                    bl4 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.USE_TASKS) {
                    bl5 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.PRIVATE_KEY_METHOD) {
                    openSslPrivateKeyMethod = (OpenSslPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD) {
                    openSslAsyncPrivateKeyMethod = (OpenSslAsyncPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) {
                    openSslCertificateCompressionConfig = (OpenSslCertificateCompressionConfig)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES) {
                    n2 = (Integer)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.GROUPS) {
                    String[] stringArray2 = (String[])entry.getValue();
                    serializable = new LinkedHashSet<String>(stringArray2.length);
                    for (String string2 : stringArray2) {
                        serializable.add(GroupsConverter.toOpenSsl(string2));
                    }
                    objectArray = serializable.toArray(EmptyArrays.EMPTY_STRINGS);
                    continue;
                }
                logger.debug("Skipping unsupported " + SslContextOption.class.getSimpleName() + ": " + entry.getKey());
            }
        }
        if (openSslPrivateKeyMethod != null && openSslAsyncPrivateKeyMethod != null) {
            throw new IllegalArgumentException("You can either only use " + OpenSslAsyncPrivateKeyMethod.class.getSimpleName() + " or " + OpenSslPrivateKeyMethod.class.getSimpleName());
        }
        this.tlsFalseStart = bl4;
        this.leak = bl3 ? leakDetector.track((Object)this) : null;
        this.mode = n;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth")) : ClientAuth.NONE;
        this.protocols = stringArray == null ? OpenSsl.defaultProtocols(n == 0) : stringArray;
        this.endpointIdentificationAlgorithm = string;
        this.enableOcsp = bl2;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        Object[] objectArray2 = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherSuiteFilter, (String)"cipherFilter")).filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites());
        LinkedHashSet linkedHashSet = new LinkedHashSet(objectArray2.length);
        Collections.addAll(linkedHashSet, objectArray2);
        this.unmodifiableCiphers = new ArrayList<String>(linkedHashSet);
        this.apn = (OpenSslApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)openSslApplicationProtocolNegotiator, (String)"apn");
        int n3 = 0;
        try {
            List<String> list;
            boolean bl6 = OpenSsl.isTlsv13Supported();
            boolean bl7 = false;
            try {
                int n4 = 30;
                if (bl6) {
                    n4 |= 0x20;
                }
                this.ctx = SSLContext.make((int)n4, (int)n);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            StringBuilder stringBuilder = new StringBuilder();
            serializable = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (bl6) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, stringBuilder, serializable, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)stringBuilder.toString(), (boolean)false);
                    if (bl6) {
                        String string3 = OpenSsl.checkTls13Ciphers(logger, ((StringBuilder)serializable).toString());
                        SSLContext.setCipherSuite((long)this.ctx, (String)string3, (boolean)true);
                        if (!string3.isEmpty()) {
                            bl7 = true;
                        }
                    }
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            int n5 = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (stringBuilder.length() == 0) {
                n5 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            if (!bl6) {
                n5 |= SSL.SSL_OP_NO_TLSv1_3;
            }
            this.hasTLSv13Cipher = bl7;
            SSLContext.setOptions((long)this.ctx, (int)n5);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            if (!(list = openSslApplicationProtocolNegotiator.protocols()).isEmpty()) {
                String[] stringArray3 = list.toArray(EmptyArrays.EMPTY_STRINGS);
                int n6 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (bl2) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl5);
            if (openSslPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
            }
            if (openSslAsyncPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (AsyncSSLPrivateKeyMethod)new AsyncPrivateKeyMethod(this.engineMap, openSslAsyncPrivateKeyMethod));
            }
            if (openSslCertificateCompressionConfig != null) {
                block20: for (OpenSslCertificateCompressionConfig.AlgorithmConfig algorithmConfig : openSslCertificateCompressionConfig) {
                    CompressionAlgorithm compressionAlgorithm = new CompressionAlgorithm(this.engineMap, algorithmConfig.algorithm());
                    switch (algorithmConfig.mode()) {
                        case Decompress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_DECOMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                        case Compress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_COMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                        case Both: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_BOTH, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block20;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (n2 != null) {
                SSLContext.setMaxCertList((long)this.ctx, (int)n2);
            }
            if (objectArray.length > 0 && !SSLContext.setCurvesList((long)this.ctx, (String[])objectArray)) {
                String string4 = "failed to set curves / groups suite: " + Arrays.toString(objectArray);
                int n7 = SSL.getLastErrorNumber();
                if (n7 != 0) {
                    string4 = string4 + ". " + SSL.getErrorString((long)n7);
                }
                throw new SSLException(string4);
            }
            n3 = 1;
        }
        finally {
            if (n3 == 0) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior) {
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n) {
        return this.newEngine0(byteBufAllocator, string, n, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n, false), bl, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl, executor, this.resumptionController);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n, false), false, executor, this.resumptionController);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n, bl, true, this.endpointIdentificationAlgorithm);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.sslCtxPointer();
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    @Deprecated
    public void setRejectRemoteInitiatedRenegotiation(boolean bl) {
        if (!bl) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    @Deprecated
    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    public void setBioNonApplicationBufferSize(int n) {
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero((int)n, (String)"bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final long sslCtxPointer() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.getSslCtx((long)this.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public final void setPrivateKeyMethod(OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
        ObjectUtil.checkNotNull((Object)openSslPrivateKeyMethod, (String)"method");
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public final void setUseTasks(boolean bl) {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl);
        }
        finally {
            lock.unlock();
        }
    }

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = new LazyX509Certificate(byArray[i]);
        }
        return x509CertificateArray;
    }

    @Deprecated
    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        return ReferenceCountedOpenSslContext.chooseTrustManager(trustManagerArray, null);
    }

    static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray, ResumptionController resumptionController) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            if (PlatformDependent.javaVersion() >= 7) {
                if (resumptionController != null) {
                    x509TrustManager = (X509TrustManager)resumptionController.wrapIfNeeded(x509TrustManager);
                }
                if (ReferenceCountedOpenSslContext.useExtendedTrustManager(x509TrustManager = OpenSslX509TrustManagerWrapper.wrapIfNeeded(x509TrustManager))) {
                    x509TrustManager = new EnhancingX509ExtendedTrustManager(x509TrustManager);
                }
            }
            return x509TrustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    public final ReferenceCounted retain(int n) {
        this.refCnt.retain(n);
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    public final boolean release(int n) {
        return this.refCnt.release(n);
    }

    static void setKeyMaterial(long l, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l2 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio((long)l, (long)l3, (long)l2, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l, (long)l4, (boolean)true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l2);
            ReferenceCountedOpenSslContext.freeBio(l3);
            ReferenceCountedOpenSslContext.freeBio(l4);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l) {
        if (l != 0L) {
            SSL.freeBIO((long)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey privateKey) {
        if (privateKey == null) {
            return 0L;
        }
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... x509CertificateArray) {
        if (x509CertificateArray == null) {
            return 0L;
        }
        ObjectUtil.checkNonEmpty((Object[])x509CertificateArray, (String)"certChain");
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) {
        try {
            long l;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l2;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) {
        try {
            long l = SSL.newMemBIO();
            int n = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n) != n) {
                SSL.freeBIO((long)l);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l2 = l;
            return l2;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)keyManagerFactory).newProvider(string);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), string);
    }

    private static ReferenceCountedOpenSslEngine retrieveEngine(OpenSslEngineMap openSslEngineMap, long l) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = openSslEngineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            throw new SSLException("Could not find a " + StringUtil.simpleClassName(ReferenceCountedOpenSslEngine.class) + " for sslPointer " + l);
        }
        return referenceCountedOpenSslEngine;
    }

    private static byte[] verifyResult(byte[] byArray) {
        if (byArray == null) {
            throw new SignatureException();
        }
        return byArray;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        CLIENT_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)false);
        CLIENT_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)false);
        SERVER_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.sessionCacheServer", (boolean)true);
        CLIENT_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.sessionCacheClient", (boolean)true);
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        Integer n = null;
        try {
            String string = SystemPropertyUtil.get((String)"jdk.tls.ephemeralDHKeySize");
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n;
    }

    private static final class CompressionAlgorithm
    implements CertificateCompressionAlgo {
        private final OpenSslEngineMap engineMap;
        private final OpenSslCertificateCompressionAlgorithm compressionAlgorithm;

        CompressionAlgorithm(OpenSslEngineMap openSslEngineMap, OpenSslCertificateCompressionAlgorithm openSslCertificateCompressionAlgorithm) {
            this.engineMap = openSslEngineMap;
            this.compressionAlgorithm = openSslCertificateCompressionAlgorithm;
        }

        public byte[] compress(long l, byte[] byArray) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
            return this.compressionAlgorithm.compress(referenceCountedOpenSslEngine, byArray);
        }

        public byte[] decompress(long l, int n, byte[] byArray) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
            return this.compressionAlgorithm.decompress(referenceCountedOpenSslEngine, n, byArray);
        }

        public int algorithmId() {
            return this.compressionAlgorithm.algorithmId();
        }
    }

    private static final class AsyncPrivateKeyMethod
    implements AsyncSSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslAsyncPrivateKeyMethod keyMethod;

        AsyncPrivateKeyMethod(OpenSslEngineMap openSslEngineMap, OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod) {
            this.engineMap = openSslEngineMap;
            this.keyMethod = openSslAsyncPrivateKeyMethod;
        }

        public void sign(long l, int n, byte[] byArray, ResultCallback<byte[]> resultCallback) {
            try {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
                this.keyMethod.sign(referenceCountedOpenSslEngine, n, byArray).addListener((GenericFutureListener)new ResultCallbackListener(referenceCountedOpenSslEngine, l, resultCallback));
            }
            catch (SSLException sSLException) {
                resultCallback.onError(l, (Throwable)sSLException);
            }
        }

        public void decrypt(long l, byte[] byArray, ResultCallback<byte[]> resultCallback) {
            try {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
                this.keyMethod.decrypt(referenceCountedOpenSslEngine, byArray).addListener((GenericFutureListener)new ResultCallbackListener(referenceCountedOpenSslEngine, l, resultCallback));
            }
            catch (SSLException sSLException) {
                resultCallback.onError(l, (Throwable)sSLException);
            }
        }

        private static final class ResultCallbackListener
        implements FutureListener<byte[]> {
            private final ReferenceCountedOpenSslEngine engine;
            private final long ssl;
            private final ResultCallback<byte[]> resultCallback;

            ResultCallbackListener(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, long l, ResultCallback<byte[]> resultCallback) {
                this.engine = referenceCountedOpenSslEngine;
                this.ssl = l;
                this.resultCallback = resultCallback;
            }

            public void operationComplete(Future<byte[]> future) {
                Throwable throwable = future.cause();
                if (throwable == null) {
                    try {
                        byte[] byArray = ReferenceCountedOpenSslContext.verifyResult((byte[])future.getNow());
                        this.resultCallback.onSuccess(this.ssl, (Object)byArray);
                        return;
                    }
                    catch (SignatureException signatureException) {
                        throwable = signatureException;
                        this.engine.initHandshakeException(signatureException);
                    }
                }
                this.resultCallback.onError(this.ssl, throwable);
            }
        }
    }

    private static final class PrivateKeyMethod
    implements SSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslPrivateKeyMethod keyMethod;

        PrivateKeyMethod(OpenSslEngineMap openSslEngineMap, OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
            this.engineMap = openSslEngineMap;
            this.keyMethod = openSslPrivateKeyMethod;
        }

        public byte[] sign(long l, int n, byte[] byArray) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
            try {
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.sign(referenceCountedOpenSslEngine, n, byArray));
            }
            catch (Exception exception) {
                referenceCountedOpenSslEngine.initHandshakeException(exception);
                throw exception;
            }
        }

        public byte[] decrypt(long l, byte[] byArray) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l);
            try {
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.decrypt(referenceCountedOpenSslEngine, byArray));
            }
            catch (Exception exception) {
                referenceCountedOpenSslEngine.initHandshakeException(exception);
                throw exception;
            }
        }
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        @Override
        public ReferenceCountedOpenSslEngine remove(long l) {
            return this.engines.remove(l);
        }

        @Override
        public void add(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
            this.engines.put(referenceCountedOpenSslEngine.sslPointer(), referenceCountedOpenSslEngine);
        }

        @Override
        public ReferenceCountedOpenSslEngine get(long l) {
            return this.engines.get(l);
        }
    }

    static abstract class AbstractCertificateVerifier
    extends CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }

        public final int verify(long l, byte[][] byArray, String string) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
            if (referenceCountedOpenSslEngine == null) {
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
            X509Certificate[] x509CertificateArray = ReferenceCountedOpenSslContext.certificates(byArray);
            try {
                this.verify(referenceCountedOpenSslEngine, x509CertificateArray, string);
                return CertificateVerifier.X509_V_OK;
            }
            catch (Throwable throwable) {
                logger.debug("verification of certificate failed", throwable);
                referenceCountedOpenSslEngine.initHandshakeException(throwable);
                if (throwable instanceof OpenSslCertificateException) {
                    return ((OpenSslCertificateException)throwable).errorCode();
                }
                if (throwable instanceof CertificateExpiredException) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (throwable instanceof CertificateNotYetValidException) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (PlatformDependent.javaVersion() >= 7) {
                    return AbstractCertificateVerifier.translateToError(throwable);
                }
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
        }

        private static int translateToError(Throwable throwable) {
            if (throwable instanceof CertificateRevokedException) {
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof CertPathValidatorException)) continue;
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable2;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (reason != CertPathValidatorException.BasicReason.REVOKED) continue;
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
        }

        abstract void verify(ReferenceCountedOpenSslEngine var1, X509Certificate[] var2, String var3);
    }
}

