/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.opencv.opencv_core.AbstractArray;
import org.bytedeco.opencv.opencv_core.IplROI;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractMat
extends AbstractArray {
    public static final Mat EMPTY = null;

    public AbstractMat(Pointer pointer) {
        super(pointer);
    }

    public abstract void create(int var1, int var2, int var3);

    public abstract void release();

    public abstract int type();

    public abstract int depth();

    public abstract int channels();

    public abstract int rows();

    public abstract int cols();

    public abstract BytePointer data();

    public abstract int size(int var1);

    public abstract long step(int var1);

    public abstract int dims();

    public abstract long elemSize1();

    @Override
    public int arrayChannels() {
        return this.channels();
    }

    @Override
    public int arrayDepth() {
        switch (this.depth()) {
            case 0: {
                return 8;
            }
            case 1: {
                return -2147483640;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return -2147483632;
            }
            case 4: {
                return -2147483616;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        assert (false);
        return -1;
    }

    @Override
    public int arrayOrigin() {
        return 0;
    }

    @Override
    public void arrayOrigin(int n) {
    }

    @Override
    public int arrayWidth() {
        return this.cols();
    }

    @Override
    public int arrayHeight() {
        return this.rows();
    }

    @Override
    public IplROI arrayROI() {
        return null;
    }

    @Override
    public long arraySize() {
        return this.step(0) * (long)this.size(0);
    }

    @Override
    public BytePointer arrayData() {
        return this.data();
    }

    @Override
    public long arrayStep() {
        return this.step(0);
    }

    @Override
    public <I extends Indexer> I createIndexer(boolean bl) {
        BytePointer bytePointer = this.arrayData();
        long l = this.arraySize();
        int n = this.dims();
        int n2 = this.depth();
        long l2 = this.elemSize1();
        long[] lArray = new long[n + 1];
        long[] lArray2 = new long[n + 1];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.size(i);
            long l3 = this.step(i);
            if (l3 % l2 != 0L) {
                throw new UnsupportedOperationException("Step is not a multiple of element size");
            }
            lArray2[i] = l3 / l2;
        }
        lArray[n] = this.arrayChannels();
        lArray2[n] = 1L;
        switch (n2) {
            case 0: {
                return (I)UByteIndexer.create((BytePointer)bytePointer.capacity(l), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 1: {
                return (I)ByteIndexer.create((BytePointer)bytePointer.capacity(l), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 2: {
                return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)bytePointer).capacity(l / 2L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 3: {
                return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)bytePointer).capacity(l / 2L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 4: {
                return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)bytePointer).capacity(l / 4L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 5: {
                return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)bytePointer).capacity(l / 4L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 6: {
                return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)bytePointer).capacity(l / 8L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
        }
        assert (false);
        return null;
    }
}

