/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdVector;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.AbstractMat;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.opencv_core.MatAllocator;
import org.bytedeco.opencv.opencv_core.MatExpr;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Point2d;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Point3d;
import org.bytedeco.opencv.opencv_core.Point3f;
import org.bytedeco.opencv.opencv_core.Point3i;
import org.bytedeco.opencv.opencv_core.Range;
import org.bytedeco.opencv.opencv_core.RangeVector;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Scalar4i;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_core.UMatData;

@Namespace(value="cv")
@NoOffset
@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public class Mat
extends AbstractMat {
    private Pointer pointer;
    public static final int MAGIC_VAL = 1124007936;
    public static final int AUTO_STEP = 0;
    public static final int CONTINUOUS_FLAG = 16384;
    public static final int SUBMATRIX_FLAG = 32768;
    public static final int MAGIC_MASK = -65536;
    public static final int TYPE_MASK = 4095;
    public static final int DEPTH_MASK = 7;

    public Mat(Pointer pointer) {
        super(pointer);
    }

    public Mat(long l) {
        super(null);
        this.allocateArray(l);
    }

    private native void allocateArray(long var1);

    public Mat position(long l) {
        return (Mat)super.position(l);
    }

    public Mat getPointer(long l) {
        return (Mat)new Mat((Pointer)this).offsetAddress(l);
    }

    public Mat() {
        super(null);
        this.allocate();
    }

    @NoException
    private native void allocate();

    public Mat(int n, int n2, int n3) {
        super(null);
        this.allocate(n, n2, n3);
    }

    private native void allocate(int var1, int var2, int var3);

    public Mat(@ByVal Size size, int n) {
        super(null);
        this.allocate(size, n);
    }

    private native void allocate(@ByVal Size var1, int var2);

    public Mat(int n, int n2, int n3, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(n, n2, n3, scalar);
    }

    private native void allocate(int var1, int var2, int var3, @Const @ByRef Scalar var4);

    public Mat(@ByVal Size size, int n, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(size, n, scalar);
    }

    private native void allocate(@ByVal Size var1, int var2, @Const @ByRef Scalar var3);

    public Mat(int n, @Const IntPointer intPointer, int n2) {
        super(null);
        this.allocate(n, intPointer, n2);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3);

    public Mat(int n, @Const IntBuffer intBuffer, int n2) {
        super(null);
        this.allocate(n, intBuffer, n2);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3);

    public Mat(int n, @Const int[] nArray, int n2) {
        super(null);
        this.allocate(n, nArray, n2);
    }

    private native void allocate(int var1, @Const int[] var2, int var3);

    public Mat(@StdVector IntPointer intPointer, int n) {
        super(null);
        this.allocate(intPointer, n);
    }

    private native void allocate(@StdVector IntPointer var1, int var2);

    public Mat(@StdVector IntBuffer intBuffer, int n) {
        super(null);
        this.allocate(intBuffer, n);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2);

    public Mat(@StdVector int[] nArray, int n) {
        super(null);
        this.allocate(nArray, n);
    }

    private native void allocate(@StdVector int[] var1, int var2);

    public Mat(int n, @Const IntPointer intPointer, int n2, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(n, intPointer, n2, scalar);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, @Const @ByRef Scalar var4);

    public Mat(int n, @Const IntBuffer intBuffer, int n2, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(n, intBuffer, n2, scalar);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, @Const @ByRef Scalar var4);

    public Mat(int n, @Const int[] nArray, int n2, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(n, nArray, n2, scalar);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, @Const @ByRef Scalar var4);

    public Mat(@StdVector IntPointer intPointer, int n, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(intPointer, n, scalar);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@StdVector IntBuffer intBuffer, int n, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(intBuffer, n, scalar);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@StdVector int[] nArray, int n, @Const @ByRef Scalar scalar) {
        super(null);
        this.allocate(nArray, n, scalar);
    }

    private native void allocate(@StdVector int[] var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@Const @ByRef Mat mat) {
        super(null);
        this.allocate(mat);
    }

    private native void allocate(@Const @ByRef Mat var1);

    public Mat(int n, int n2, int n3, Pointer pointer, @Cast(value={"size_t"}) long l) {
        super(null);
        this.allocate(n, n2, n3, pointer, l);
        this.pointer = pointer;
    }

    private native void allocate(int var1, int var2, int var3, Pointer var4, @Cast(value={"size_t"}) long var5);

    public Mat(int n, int n2, int n3, Pointer pointer) {
        this(n, n2, n3, pointer, 0L);
    }

    public Mat(CvArr cvArr) {
        super(opencv_core.cvarrToMat(cvArr));
        this.pointer = cvArr;
    }

    public Mat(int n, int n2, int n3, Pointer pointer, boolean bl) {
        super(null);
        if (bl) {
            this.allocate(n, n2, n3);
            this.data().put(pointer);
        } else {
            this.allocate(n, n2, n3, pointer, 0L);
            this.pointer = pointer;
        }
    }

    public Mat(int n, Pointer pointer, boolean bl) {
        this((int)Math.min(pointer.limit() - pointer.position(), Integer.MAX_VALUE), 1, n, pointer, bl);
    }

    public Mat(Point point, boolean bl) {
        this(opencv_core.CV_32SC2, (Pointer)point, bl);
    }

    public Mat(Point2f point2f, boolean bl) {
        this(opencv_core.CV_32FC2, (Pointer)point2f, bl);
    }

    public Mat(Point2d point2d, boolean bl) {
        this(opencv_core.CV_64FC2, (Pointer)point2d, bl);
    }

    public Mat(Point3i point3i, boolean bl) {
        this(opencv_core.CV_32SC3, (Pointer)point3i, bl);
    }

    public Mat(Point3f point3f, boolean bl) {
        this(opencv_core.CV_32FC3, (Pointer)point3f, bl);
    }

    public Mat(Point3d point3d, boolean bl) {
        this(opencv_core.CV_64FC3, (Pointer)point3d, bl);
    }

    public Mat(Scalar scalar, boolean bl) {
        this(opencv_core.CV_64FC4, (Pointer)scalar, bl);
    }

    public Mat(Scalar4i scalar4i, boolean bl) {
        this(opencv_core.CV_32SC4, (Pointer)scalar4i, bl);
    }

    public Mat(Point point) {
        this(point, false);
    }

    public Mat(Point2f point2f) {
        this(point2f, false);
    }

    public Mat(Point2d point2d) {
        this(point2d, false);
    }

    public Mat(Point3i point3i) {
        this(point3i, false);
    }

    public Mat(Point3f point3f) {
        this(point3f, false);
    }

    public Mat(Point3d point3d) {
        this(point3d, false);
    }

    public Mat(Scalar scalar) {
        this(scalar, false);
    }

    public Mat(Scalar4i scalar4i) {
        this(scalar4i, false);
    }

    public Mat(byte ... byArray) {
        this(byArray, false);
    }

    public Mat(short ... sArray) {
        this(sArray, false);
    }

    public Mat(byte[] byArray, boolean bl) {
        this(byArray.length, 1, bl ? opencv_core.CV_8SC1 : opencv_core.CV_8UC1);
        this.data().put(byArray);
    }

    public Mat(short[] sArray, boolean bl) {
        this(sArray.length, 1, bl ? opencv_core.CV_16SC1 : opencv_core.CV_16UC1);
        new ShortPointer((Pointer)this.data()).put(sArray);
    }

    public Mat(int ... nArray) {
        this(nArray.length, 1, opencv_core.CV_32SC1);
        new IntPointer((Pointer)this.data()).put(nArray);
    }

    public Mat(double ... dArray) {
        this(dArray.length, 1, opencv_core.CV_64FC1);
        new DoublePointer((Pointer)this.data()).put(dArray);
    }

    public Mat(float ... fArray) {
        this(fArray.length, 1, opencv_core.CV_32FC1);
        new FloatPointer((Pointer)this.data()).put(fArray);
    }

    public Mat(BytePointer bytePointer) {
        this(bytePointer, false);
    }

    public Mat(ShortPointer shortPointer) {
        this(shortPointer, false);
    }

    public Mat(BytePointer bytePointer, boolean bl) {
        this(bytePointer, bl, false);
    }

    public Mat(ShortPointer shortPointer, boolean bl) {
        this(shortPointer, bl, false);
    }

    public Mat(IntPointer intPointer) {
        this(intPointer, false);
    }

    public Mat(FloatPointer floatPointer) {
        this(floatPointer, false);
    }

    public Mat(DoublePointer doublePointer) {
        this(doublePointer, false);
    }

    public Mat(BytePointer bytePointer, boolean bl, boolean bl2) {
        this(bl ? opencv_core.CV_8SC1 : opencv_core.CV_8UC1, (Pointer)bytePointer, bl2);
    }

    public Mat(ShortPointer shortPointer, boolean bl, boolean bl2) {
        this(bl ? opencv_core.CV_16SC1 : opencv_core.CV_16UC1, (Pointer)shortPointer, bl2);
    }

    public Mat(IntPointer intPointer, boolean bl) {
        this(opencv_core.CV_32SC1, (Pointer)intPointer, bl);
    }

    public Mat(FloatPointer floatPointer, boolean bl) {
        this(opencv_core.CV_32FC1, (Pointer)floatPointer, bl);
    }

    public Mat(DoublePointer doublePointer, boolean bl) {
        this(opencv_core.CV_64FC1, (Pointer)doublePointer, bl);
    }

    public Mat(@ByVal Size size, int n, Pointer pointer, @Cast(value={"size_t"}) long l) {
        super(null);
        this.allocate(size, n, pointer, l);
    }

    private native void allocate(@ByVal Size var1, int var2, Pointer var3, @Cast(value={"size_t"}) long var4);

    public Mat(@ByVal Size size, int n, Pointer pointer) {
        super(null);
        this.allocate(size, n, pointer);
    }

    private native void allocate(@ByVal Size var1, int var2, Pointer var3);

    public Mat(int n, @Const IntPointer intPointer, int n2, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(n, intPointer, n2, pointer, sizeTPointer);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int n, @Const IntPointer intPointer, int n2, Pointer pointer) {
        super(null);
        this.allocate(n, intPointer, n2, pointer);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, Pointer var4);

    public Mat(int n, @Const IntBuffer intBuffer, int n2, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(n, intBuffer, n2, pointer, sizeTPointer);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int n, @Const IntBuffer intBuffer, int n2, Pointer pointer) {
        super(null);
        this.allocate(n, intBuffer, n2, pointer);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, Pointer var4);

    public Mat(int n, @Const int[] nArray, int n2, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(n, nArray, n2, pointer, sizeTPointer);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int n, @Const int[] nArray, int n2, Pointer pointer) {
        super(null);
        this.allocate(n, nArray, n2, pointer);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, Pointer var4);

    public Mat(@StdVector IntPointer intPointer, int n, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(intPointer, n, pointer, sizeTPointer);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector IntPointer intPointer, int n, Pointer pointer) {
        super(null);
        this.allocate(intPointer, n, pointer);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, Pointer var3);

    public Mat(@StdVector IntBuffer intBuffer, int n, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(intBuffer, n, pointer, sizeTPointer);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector IntBuffer intBuffer, int n, Pointer pointer) {
        super(null);
        this.allocate(intBuffer, n, pointer);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, Pointer var3);

    public Mat(@StdVector int[] nArray, int n, Pointer pointer, @Cast(value={"const size_t*"}) SizeTPointer sizeTPointer) {
        super(null);
        this.allocate(nArray, n, pointer, sizeTPointer);
    }

    private native void allocate(@StdVector int[] var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector int[] nArray, int n, Pointer pointer) {
        super(null);
        this.allocate(nArray, n, pointer);
    }

    private native void allocate(@StdVector int[] var1, int var2, Pointer var3);

    public Mat(@Const @ByRef Mat mat, @Const @ByRef Range range, @Const @ByRef(nullValue="cv::Range::all()") Range range2) {
        super(null);
        this.allocate(mat, range, range2);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Range var2, @Const @ByRef(nullValue="cv::Range::all()") Range var3);

    public Mat(@Const @ByRef Mat mat, @Const @ByRef Range range) {
        super(null);
        this.allocate(mat, range);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Range var2);

    public Mat(@Const @ByRef Mat mat, @Const @ByRef Rect rect) {
        super(null);
        this.allocate(mat, rect);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Rect var2);

    public Mat(@Const @ByRef Mat mat, @Const @ByRef RangeVector rangeVector) {
        super(null);
        this.allocate(mat, rangeVector);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef RangeVector var2);

    public Mat(@Const @ByRef GpuMat gpuMat) {
        super(null);
        this.allocate(gpuMat);
    }

    private native void allocate(@Const @ByRef GpuMat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef Mat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef MatExpr var1);

    @ByVal
    public native UMat getUMat(@Cast(value={"cv::AccessFlag"}) int var1, @Cast(value={"cv::UMatUsageFlags"}) int var2);

    @ByVal
    public native UMat getUMat(@Cast(value={"cv::AccessFlag"}) int var1);

    @ByVal
    public native Mat row(int var1);

    @ByVal
    public native Mat col(int var1);

    @ByVal
    public native Mat rowRange(int var1, int var2);

    @ByVal
    public native Mat rowRange(@Const @ByRef Range var1);

    @ByVal
    public native Mat colRange(int var1, int var2);

    @ByVal
    public native Mat colRange(@Const @ByRef Range var1);

    @ByVal
    public native Mat diag(int var1);

    @ByVal
    public native Mat diag();

    @ByVal
    public static native Mat diag(@Const @ByRef Mat var0);

    @ByVal
    public native Mat clone();

    public native void copyTo(@ByVal Mat var1);

    public native void copyTo(@ByVal UMat var1);

    public native void copyTo(@ByVal GpuMat var1);

    public native void copyTo(@ByVal Mat var1, @ByVal Mat var2);

    public native void copyTo(@ByVal UMat var1, @ByVal UMat var2);

    public native void copyTo(@ByVal GpuMat var1, @ByVal GpuMat var2);

    public native void convertTo(@ByVal Mat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal Mat var1, int var2);

    public native void convertTo(@ByVal UMat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal UMat var1, int var2);

    public native void convertTo(@ByVal GpuMat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal GpuMat var1, int var2);

    public native void assignTo(@ByRef Mat var1, int var2);

    public native void assignTo(@ByRef Mat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef Scalar var1);

    @ByRef
    public native Mat setTo(@ByVal Mat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") Mat var2);

    @ByRef
    public native Mat setTo(@ByVal Mat var1);

    @ByRef
    public native Mat setTo(@ByVal UMat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") UMat var2);

    @ByRef
    public native Mat setTo(@ByVal UMat var1);

    @ByRef
    public native Mat setTo(@ByVal GpuMat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") GpuMat var2);

    @ByRef
    public native Mat setTo(@ByVal GpuMat var1);

    @ByVal
    public native Mat reshape(int var1, int var2);

    @ByVal
    public native Mat reshape(int var1);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const IntPointer var3);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const IntBuffer var3);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const int[] var3);

    @ByVal
    public native Mat reshape(int var1, @StdVector IntPointer var2);

    @ByVal
    public native Mat reshape(int var1, @StdVector IntBuffer var2);

    @ByVal
    public native Mat reshape(int var1, @StdVector int[] var2);

    @ByVal
    public native MatExpr t();

    @ByVal
    public native MatExpr inv(int var1);

    @ByVal
    public native MatExpr inv();

    @ByVal
    public native MatExpr mul(@ByVal Mat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal Mat var1);

    @ByVal
    public native MatExpr mul(@ByVal UMat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal UMat var1);

    @ByVal
    public native MatExpr mul(@ByVal GpuMat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal GpuMat var1);

    @ByVal
    public native Mat cross(@ByVal Mat var1);

    @ByVal
    public native Mat cross(@ByVal UMat var1);

    @ByVal
    public native Mat cross(@ByVal GpuMat var1);

    public native double dot(@ByVal Mat var1);

    public native double dot(@ByVal UMat var1);

    public native double dot(@ByVal GpuMat var1);

    @ByVal
    public static native MatExpr zeros(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr zeros(@ByVal Size var0, int var1);

    @ByVal
    public static native MatExpr ones(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr ones(@ByVal Size var0, int var1);

    @ByVal
    public static native MatExpr eye(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr eye(@ByVal Size var0, int var1);

    @Override
    public native void create(int var1, int var2, int var3);

    public native void create(@ByVal Size var1, int var2);

    public native void create(int var1, @Const IntPointer var2, int var3);

    public native void create(int var1, @Const IntBuffer var2, int var3);

    public native void create(int var1, @Const int[] var2, int var3);

    public native void create(@StdVector IntPointer var1, int var2);

    public native void create(@StdVector IntBuffer var1, int var2);

    public native void create(@StdVector int[] var1, int var2);

    public native void addref();

    @Override
    public native void release();

    @Name(value={"deallocate"})
    public native void _deallocate();

    public native void copySize(@Const @ByRef Mat var1);

    public native void reserve(@Cast(value={"size_t"}) long var1);

    public native void reserveBuffer(@Cast(value={"size_t"}) long var1);

    public native void resize(@Cast(value={"size_t"}) long var1);

    public native void resize(@Cast(value={"size_t"}) long var1, @Const @ByRef Scalar var3);

    public native void push_back_(@Const Pointer var1);

    public native void push_back(@Const @ByRef Mat var1);

    public native void pop_back(@Cast(value={"size_t"}) long var1);

    public native void pop_back();

    public native void locateROI(@ByRef Size var1, @ByRef Point var2);

    @ByRef
    public native Mat adjustROI(int var1, int var2, int var3, int var4);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@ByVal Range var1, @ByVal Range var2);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const @ByRef Rect var1);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const Range var1);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const @ByRef RangeVector var1);

    @Cast(value={"bool"})
    public native boolean isContinuous();

    @Cast(value={"bool"})
    public native boolean isSubmatrix();

    @Cast(value={"size_t"})
    public native long elemSize();

    @Override
    @Cast(value={"size_t"})
    public native long elemSize1();

    @Override
    public native int type();

    @Override
    public native int depth();

    @Override
    public native int channels();

    @Cast(value={"size_t"})
    public native long step1(int var1);

    @Cast(value={"size_t"})
    public native long step1();

    @Cast(value={"bool"})
    public native boolean empty();

    @Cast(value={"size_t"})
    public native long total();

    @Cast(value={"size_t"})
    public native long total(int var1, int var2);

    @Cast(value={"size_t"})
    public native long total(int var1);

    public native int checkVector(int var1, int var2, @Cast(value={"bool"}) boolean var3);

    public native int checkVector(int var1);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1);

    @Cast(value={"uchar*"})
    public native BytePointer ptr();

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1, int var2);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1, int var2, int var3);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(@Const IntPointer var1);

    @Cast(value={"uchar*"})
    public native ByteBuffer ptr(@Const IntBuffer var1);

    @Cast(value={"uchar*"})
    public native byte[] ptr(@Const int[] var1);

    public native int flags();

    public native Mat flags(int var1);

    @Override
    public native int dims();

    public native Mat dims(int var1);

    @Override
    public native int rows();

    public native Mat rows(int var1);

    @Override
    public native int cols();

    public native Mat cols(int var1);

    @Override
    @Cast(value={"uchar*"})
    public native BytePointer data();

    public native Mat data(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer datastart();

    public native Mat datastart(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer dataend();

    public native Mat dataend(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer datalimit();

    public native Mat datalimit(BytePointer var1);

    public native MatAllocator allocator();

    public native Mat allocator(MatAllocator var1);

    public static native MatAllocator getStdAllocator();

    public static native MatAllocator getDefaultAllocator();

    public static native void setDefaultAllocator(MatAllocator var0);

    public native void updateContinuityFlag();

    public native UMatData u();

    public native Mat u(UMatData var1);

    @ByVal
    public native Size size();

    @Override
    @MemberGetter
    public native int size(int var1);

    @MemberGetter
    public native long step();

    @Override
    @MemberGetter
    public native long step(int var1);

    static {
        Loader.load();
    }
}

