/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Mat> >"})
@Properties(inherit={opencv_core.class})
public class MatVectorVector
extends Pointer {
    public MatVectorVector(Pointer pointer) {
        super(pointer);
    }

    public MatVectorVector(MatVector matVector) {
        this(1L);
        this.put(0L, matVector);
    }

    public MatVectorVector(MatVector ... matVectorArray) {
        this(matVectorArray.length);
        this.put(matVectorArray);
    }

    public MatVectorVector() {
        this.allocate();
    }

    public MatVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native MatVectorVector put(@ByRef MatVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public MatVector front() {
        return this.get(0L);
    }

    public MatVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native MatVector get(@Cast(value={"size_t"}) long var1);

    public native MatVectorVector put(@Cast(value={"size_t"}) long var1, MatVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef MatVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public MatVector[] get() {
        MatVector[] matVectorArray = new MatVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < matVectorArray.length; ++i) {
            matVectorArray[i] = this.get(i);
        }
        return matVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public MatVector pop_back() {
        long l = this.size();
        MatVector matVector = this.get(l - 1L);
        this.resize(l - 1L);
        return matVector;
    }

    public MatVectorVector push_back(MatVector matVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, matVector);
    }

    public MatVectorVector put(MatVector matVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, matVector);
    }

    public MatVectorVector put(MatVector ... matVectorArray) {
        if (this.size() != (long)matVectorArray.length) {
            this.resize(matVectorArray.length);
        }
        for (int i = 0; i < matVectorArray.length; ++i) {
            this.put(i, matVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native MatVector get();
    }
}

