/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_dnn;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.presets.opencv_dnn;

@Name(value={"std::vector<cv::Mat*>"})
@Properties(inherit={opencv_dnn.class})
public class MatPointerVector
extends Pointer {
    public MatPointerVector(Pointer pointer) {
        super(pointer);
    }

    public MatPointerVector(Mat mat) {
        this(1L);
        this.put(0L, mat);
    }

    public MatPointerVector(Mat ... matArray) {
        this(matArray.length);
        this.put(matArray);
    }

    public MatPointerVector() {
        this.allocate();
    }

    public MatPointerVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native MatPointerVector put(@ByRef MatPointerVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Mat front() {
        return this.get(0L);
    }

    public Mat back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native Mat get(@Cast(value={"size_t"}) long var1);

    public native MatPointerVector put(@Cast(value={"size_t"}) long var1, Mat var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, Mat var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Mat[] get() {
        Mat[] matArray = new Mat[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < matArray.length; ++i) {
            matArray[i] = this.get(i);
        }
        return matArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Mat pop_back() {
        long l = this.size();
        Mat mat = this.get(l - 1L);
        this.resize(l - 1L);
        return mat;
    }

    public MatPointerVector push_back(Mat mat) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, mat);
    }

    public MatPointerVector put(Mat mat) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, mat);
    }

    public MatPointerVector put(Mat ... matArray) {
        if (this.size() != (long)matArray.length) {
            this.resize(matArray.length);
        }
        for (int i = 0; i < matArray.length; ++i) {
            this.put(i, matArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Const
        public native Mat get();
    }
}

