/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_dnn;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_dnn.MatShapeVector;
import org.bytedeco.opencv.presets.opencv_dnn;

@Name(value={"std::vector<std::vector<cv::dnn::MatShape> >"})
@Properties(inherit={opencv_dnn.class})
public class MatShapeVectorVector
extends Pointer {
    public MatShapeVectorVector(Pointer pointer) {
        super(pointer);
    }

    public MatShapeVectorVector(MatShapeVector matShapeVector) {
        this(1L);
        this.put(0L, matShapeVector);
    }

    public MatShapeVectorVector(MatShapeVector ... matShapeVectorArray) {
        this(matShapeVectorArray.length);
        this.put(matShapeVectorArray);
    }

    public MatShapeVectorVector() {
        this.allocate();
    }

    public MatShapeVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native MatShapeVectorVector put(@ByRef MatShapeVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public MatShapeVector front() {
        return this.get(0L);
    }

    public MatShapeVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native MatShapeVector get(@Cast(value={"size_t"}) long var1);

    public native MatShapeVectorVector put(@Cast(value={"size_t"}) long var1, MatShapeVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef MatShapeVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public MatShapeVector[] get() {
        MatShapeVector[] matShapeVectorArray = new MatShapeVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < matShapeVectorArray.length; ++i) {
            matShapeVectorArray[i] = this.get(i);
        }
        return matShapeVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public MatShapeVector pop_back() {
        long l = this.size();
        MatShapeVector matShapeVector = this.get(l - 1L);
        this.resize(l - 1L);
        return matShapeVector;
    }

    public MatShapeVectorVector push_back(MatShapeVector matShapeVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, matShapeVector);
    }

    public MatShapeVectorVector put(MatShapeVector matShapeVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, matShapeVector);
    }

    public MatShapeVectorVector put(MatShapeVector ... matShapeVectorArray) {
        if (this.size() != (long)matShapeVectorArray.length) {
            this.resize(matShapeVectorArray.length);
        }
        for (int i = 0; i < matShapeVectorArray.length; ++i) {
            this.put(i, matShapeVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native MatShapeVector get();
    }
}

