/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec2f>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec2fVector
extends Pointer {
    public Vec2fVector(Pointer pointer) {
        super(pointer);
    }

    public Vec2fVector(Point2f point2f) {
        this(1L);
        this.put(0L, point2f);
    }

    public Vec2fVector(Point2f ... point2fArray) {
        this(point2fArray.length);
        this.put(point2fArray);
    }

    public Vec2fVector() {
        this.allocate();
    }

    public Vec2fVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Vec2fVector put(@ByRef Vec2fVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point2f front() {
        return this.get(0L);
    }

    public Point2f back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Cast(value={"cv::Vec2f*"})
    @ByRef
    public native Point2f get(@Cast(value={"size_t"}) long var1);

    public native Vec2fVector put(@Cast(value={"size_t"}) long var1, Point2f var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec2f*"}) @ByRef Point2f var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point2f[] get() {
        Point2f[] point2fArray = new Point2f[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < point2fArray.length; ++i) {
            point2fArray[i] = this.get(i);
        }
        return point2fArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point2f pop_back() {
        long l = this.size();
        Point2f point2f = this.get(l - 1L);
        this.resize(l - 1L);
        return point2f;
    }

    public Vec2fVector push_back(Point2f point2f) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, point2f);
    }

    public Vec2fVector put(Point2f point2f) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, point2f);
    }

    public Vec2fVector put(Point2f ... point2fArray) {
        if (this.size() != (long)point2fArray.length) {
            this.resize(point2fArray.length);
        }
        for (int i = 0; i < point2fArray.length; ++i) {
            this.put(i, point2fArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"cv::Vec2f*"})
        @ByRef
        @Const
        public native Point2f get();
    }
}

