/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.e.a.a.d;
import org.e.a.i;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.ToStringUtil;
import org.jivesoftware.smack.util.XmppElementUtil;

public abstract class StanzaBuilder<B extends StanzaBuilder<B>>
implements StanzaView {
    final StanzaIdSource stanzaIdSource;
    final String stanzaId;
    i to;
    i from;
    StanzaError stanzaError;
    String language;
    MultiMap<QName, ExtensionElement> extensionElements = new MultiMap();

    protected StanzaBuilder(StanzaBuilder<?> stanzaBuilder) {
        this.stanzaIdSource = stanzaBuilder.stanzaIdSource;
        this.stanzaId = stanzaBuilder.stanzaId;
        this.to = stanzaBuilder.to;
        this.from = stanzaBuilder.from;
        this.stanzaError = stanzaBuilder.stanzaError;
        this.language = stanzaBuilder.language;
        this.extensionElements = stanzaBuilder.extensionElements.clone();
    }

    protected StanzaBuilder(StanzaIdSource stanzaIdSource) {
        this.stanzaIdSource = stanzaIdSource;
        this.stanzaId = null;
    }

    protected StanzaBuilder(String string) {
        this.stanzaIdSource = null;
        this.stanzaId = StringUtils.requireNullOrNotEmpty(string, "Stanza ID must not be the empty String");
    }

    protected StanzaBuilder(Stanza stanza, String string) {
        this(string);
        super.copyFromStanza(stanza);
    }

    protected StanzaBuilder(Stanza stanza, StanzaIdSource stanzaIdSource) {
        this(stanzaIdSource);
        super.copyFromStanza(stanza);
    }

    private void copyFromStanza(Stanza stanza) {
        this.to = stanza.getTo();
        this.from = stanza.getFrom();
        this.stanzaError = stanza.getError();
        this.language = stanza.getLanguage();
        this.extensionElements = stanza.cloneExtensionsMap();
    }

    public final B to(CharSequence charSequence) {
        return this.to(d.a((CharSequence)charSequence));
    }

    public final B to(i i2) {
        this.to = i2;
        return this.getThis();
    }

    public final B from(CharSequence charSequence) {
        return this.from(d.a((CharSequence)charSequence));
    }

    public final B from(i i2) {
        this.from = i2;
        return this.getThis();
    }

    public final B setError(StanzaError stanzaError) {
        this.stanzaError = stanzaError;
        return this.getThis();
    }

    public final B setLanguage(String string) {
        this.language = string;
        return this.getThis();
    }

    public final B addExtension(ExtensionElement extensionElement) {
        QName qName = extensionElement.getQName();
        this.extensionElements.put(qName, extensionElement);
        return this.getThis();
    }

    public final B addOptExtensions(Collection<? extends ExtensionElement> collection) {
        if (collection == null) {
            return this.getThis();
        }
        return this.addExtensions(collection);
    }

    public final B addExtensions(Collection<? extends ExtensionElement> collection) {
        for (ExtensionElement extensionElement : collection) {
            this.addExtension(extensionElement);
        }
        return this.getThis();
    }

    public final B overrideExtension(ExtensionElement extensionElement) {
        QName qName = extensionElement.getQName();
        this.extensionElements.remove(qName);
        this.extensionElements.put(qName, extensionElement);
        return this.getThis();
    }

    public final B removeExtension(String string, String string2) {
        QName qName = new QName(string2, string);
        this.extensionElements.remove(qName);
        return this.getThis();
    }

    public final B removeExtension(ExtensionElement extensionElement) {
        QName qName = extensionElement.getQName();
        List<ExtensionElement> list = this.extensionElements.getAll(qName);
        list.remove(extensionElement);
        return this.getThis();
    }

    public abstract Stanza build();

    public abstract B getThis();

    @Override
    public final String getStanzaId() {
        return this.stanzaId;
    }

    @Override
    public final i getTo() {
        return this.to;
    }

    @Override
    public final i getFrom() {
        return this.from;
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Override
    public final StanzaError getError() {
        return this.stanzaError;
    }

    @Override
    public final ExtensionElement getExtension(QName qName) {
        return this.extensionElements.getFirst(qName);
    }

    @Override
    public final List<ExtensionElement> getExtensions() {
        return this.extensionElements.values();
    }

    @Override
    public final List<ExtensionElement> getExtensions(QName qName) {
        return this.extensionElements.getAll(qName);
    }

    @Override
    public final <E extends ExtensionElement> List<E> getExtensions(Class<E> clazz) {
        return XmppElementUtil.getElementsFrom(this.extensionElements, clazz);
    }

    public final boolean willBuildStanzaWithId() {
        return this.stanzaIdSource != null || StringUtils.isNotEmpty((CharSequence)this.stanzaId);
    }

    public final void throwIfNoStanzaId() {
        if (this.willBuildStanzaWithId()) {
            return;
        }
        throw new IllegalArgumentException("The builder will not build a stanza with an ID set, although it is required");
    }

    protected abstract void addStanzaSpecificAttributes(ToStringUtil.Builder var1);

    public final String toString() {
        ToStringUtil.Builder builder = ToStringUtil.builderFor(this.getClass()).addValue("id", this.stanzaId).addValue("from", this.from).addValue("to", this.to).addValue("language", this.language).addValue("error", this.stanzaError);
        this.addStanzaSpecificAttributes(builder);
        builder.add("Extension Elements", this.extensionElements.values(), extensionElement -> extensionElement.getQName());
        return builder.build();
    }

    public static MessageBuilder buildMessage() {
        return StanzaBuilder.buildMessage(null);
    }

    public static MessageBuilder buildMessage(String string) {
        return new MessageBuilder(string);
    }

    public static MessageBuilder buildMessageFrom(Message message, String string) {
        return new MessageBuilder(message, string);
    }

    public static MessageBuilder buildMessageFrom(Message message, StanzaIdSource stanzaIdSource) {
        return new MessageBuilder(message, stanzaIdSource);
    }

    public static PresenceBuilder buildPresence() {
        return StanzaBuilder.buildPresence(null);
    }

    public static PresenceBuilder buildPresence(String string) {
        return new PresenceBuilder(string);
    }

    public static PresenceBuilder buildPresenceFrom(Presence presence, String string) {
        return new PresenceBuilder(presence, string);
    }

    public static PresenceBuilder buildPresenceFrom(Presence presence, StanzaIdSource stanzaIdSource) {
        return new PresenceBuilder(presence, stanzaIdSource);
    }

    public static IqData buildIqData(String string) {
        return new IqData(string);
    }

    public static <SB extends StanzaBuilder<?>> SB buildResponse(StanzaView stanzaView, Function<SB, String> function) {
        StanzaBuilder stanzaBuilder = (StanzaBuilder)function.apply(stanzaView.getStanzaId());
        ((StanzaBuilder)stanzaBuilder.to(stanzaView.getFrom())).from(stanzaView.getTo());
        return (SB)stanzaBuilder;
    }
}

