/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StanzaError
extends AbstractError
implements ExtensionElement {
    public static final String ERROR_CONDITION_AND_TEXT_NAMESPACE = "urn:ietf:params:xml:ns:xmpp-stanzas";
    @Deprecated
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-stanzas";
    public static final String ERROR = "error";
    public static final QName QNAME = new QName("jabber:client", "error");
    private static final Logger LOGGER = Logger.getLogger(StanzaError.class.getName());
    static final Map<Condition, Type> CONDITION_TO_TYPE = new HashMap<Condition, Type>();
    private final Condition condition;
    private final String conditionText;
    private final String errorGenerator;
    private final Type type;

    public StanzaError(Condition condition, String string, String string2, Type type, Map<String, String> map, List<ExtensionElement> list) {
        super(map, "urn:ietf:params:xml:ns:xmpp-stanzas", list);
        this.condition = Objects.requireNonNull(condition, "condition must not be null");
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            string = null;
        }
        if (string != null) {
            switch (condition) {
                case gone: 
                case redirect: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Condition text can only be set with condtion types 'gone' and 'redirect', not " + (Object)((Object)condition));
                }
            }
        }
        this.conditionText = string;
        this.errorGenerator = string2;
        if (type == null) {
            Type type2 = CONDITION_TO_TYPE.get((Object)condition);
            if (type2 == null) {
                LOGGER.warning("Could not determine type for condition: " + (Object)((Object)condition));
                type2 = Type.CANCEL;
            }
            this.type = type2;
        } else {
            this.type = type;
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Type getType() {
        return this.type;
    }

    public String getErrorGenerator() {
        return this.errorGenerator;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("XMPPError: ");
        stringBuilder.append(this.condition.toString()).append(" - ").append(this.type.toString());
        String string = this.getDescriptiveText();
        if (string != null) {
            stringBuilder.append(" [").append(string).append(']');
        }
        if (this.errorGenerator != null) {
            stringBuilder.append(". Generated by ").append(this.errorGenerator);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getElementName() {
        return QNAME.getLocalPart();
    }

    @Override
    public String getNamespace() {
        return QNAME.getNamespaceURI();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
        xmlStringBuilder.attribute("type", this.type.toString());
        xmlStringBuilder.optAttribute("by", this.errorGenerator);
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.halfOpenElement(this.condition.toString());
        xmlStringBuilder.xmlnsAttribute("urn:ietf:params:xml:ns:xmpp-stanzas");
        if (this.conditionText != null) {
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.escape(this.conditionText);
            xmlStringBuilder.closeElement(this.condition.toString());
        } else {
            xmlStringBuilder.closeEmptyElement();
        }
        this.addDescriptiveTextsAndExtensions(xmlStringBuilder);
        xmlStringBuilder.closeElement(this);
        return xmlStringBuilder;
    }

    public static Builder from(Condition condition, String string) {
        Builder builder = StanzaError.getBuilder().setCondition(condition);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("en", string);
            builder.setDescriptiveTexts(hashMap);
        }
        return builder;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(Condition condition) {
        return StanzaError.getBuilder().setCondition(condition);
    }

    public static Builder getBuilder(StanzaError stanzaError) {
        return StanzaError.getBuilder().copyFrom(stanzaError);
    }

    static {
        CONDITION_TO_TYPE.put(Condition.bad_request, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.conflict, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.feature_not_implemented, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.forbidden, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.gone, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.internal_server_error, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.item_not_found, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.jid_malformed, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.not_acceptable, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.not_allowed, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.not_authorized, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.policy_violation, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.recipient_unavailable, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.redirect, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.registration_required, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.remote_server_not_found, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.remote_server_timeout, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.resource_constraint, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.service_unavailable, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.subscription_required, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.undefined_condition, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.unexpected_request, Type.WAIT);
    }

    public static enum Condition {
        bad_request,
        conflict,
        feature_not_implemented,
        forbidden,
        gone,
        internal_server_error,
        item_not_found,
        jid_malformed,
        not_acceptable,
        not_allowed,
        not_authorized,
        policy_violation,
        recipient_unavailable,
        redirect,
        registration_required,
        remote_server_not_found,
        remote_server_timeout,
        resource_constraint,
        service_unavailable,
        subscription_required,
        undefined_condition,
        unexpected_request;


        public String toString() {
            return this.name().replace('_', '-');
        }

        public static Condition fromString(String string) {
            string = string.replace('-', '_');
            Condition condition = null;
            try {
                condition = Condition.valueOf(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not transform string '" + string + "' to XMPPErrorCondition", exception);
            }
            return condition;
        }
    }

    public static enum Type {
        WAIT,
        CANCEL,
        MODIFY,
        AUTH,
        CONTINUE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static Type fromString(String string) {
            string = string.toUpperCase(Locale.US);
            return Type.valueOf(string);
        }
    }

    public static final class Builder
    extends AbstractError.Builder<Builder> {
        private Condition condition;
        private String conditionText;
        private String errorGenerator;
        private Type type;

        private Builder() {
        }

        public Builder setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setConditionText(String string) {
            this.conditionText = string;
            return this;
        }

        public Builder setErrorGenerator(String string) {
            this.errorGenerator = string;
            return this;
        }

        public Builder copyFrom(StanzaError stanzaError) {
            this.setCondition(stanzaError.getCondition());
            this.setType(stanzaError.getType());
            this.setConditionText(stanzaError.getConditionText());
            this.setErrorGenerator(stanzaError.getErrorGenerator());
            this.setDescriptiveTexts(stanzaError.descriptiveTexts);
            this.setTextNamespace(stanzaError.textNamespace);
            this.setExtensions(stanzaError.extensions);
            return this;
        }

        public StanzaError build() {
            return new StanzaError(this.condition, this.conditionText, this.errorGenerator, this.type, this.descriptiveTexts, this.extensions);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

