/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmppElementUtil;

public final class ProviderManager {
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> extensionProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, IqProvider<IQ>> iqProviders = new ConcurrentHashMap<QName, IqProvider<IQ>>();
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> streamFeatureProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, NonzaProvider<? extends Nonza>> nonzaProviders = new ConcurrentHashMap<QName, NonzaProvider<? extends Nonza>>();

    public static void addLoader(ProviderLoader providerLoader) {
        if (providerLoader.getIQProviderInfo() != null) {
            for (IQProviderInfo abstractProviderInfo : providerLoader.getIQProviderInfo()) {
                ProviderManager.addIQProvider(abstractProviderInfo.getElementName(), abstractProviderInfo.getNamespace(), abstractProviderInfo.getProvider());
            }
        }
        if (providerLoader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : providerLoader.getExtensionProviderInfo()) {
                ProviderManager.addExtensionProvider(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace(), extensionProviderInfo.getProvider());
            }
        }
        if (providerLoader.getStreamFeatureProviderInfo() != null) {
            for (StreamFeatureProviderInfo streamFeatureProviderInfo : providerLoader.getStreamFeatureProviderInfo()) {
                ProviderManager.addStreamFeatureProvider(streamFeatureProviderInfo.getElementName(), streamFeatureProviderInfo.getNamespace(), (ExtensionElementProvider)streamFeatureProviderInfo.getProvider());
            }
        }
    }

    public static IqProvider<IQ> getIQProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        return iqProviders.get(qName);
    }

    public static List<IqProvider<IQ>> getIQProviders() {
        ArrayList<IqProvider<IQ>> arrayList = new ArrayList<IqProvider<IQ>>(iqProviders.size());
        arrayList.addAll(iqProviders.values());
        return arrayList;
    }

    public static void addIQProvider(String string, String string2, Object object) {
        ProviderManager.validate(string, string2);
        QName qName = ProviderManager.removeIQProvider(string, string2);
        if (!(object instanceof IqProvider)) {
            throw new IllegalArgumentException("Provider must be an instance of IqProvider");
        }
        iqProviders.put(qName, (IqProvider)object);
    }

    public static QName removeIQProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        iqProviders.remove(qName);
        return qName;
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        return ProviderManager.getExtensionProvider(qName);
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(QName qName) {
        return extensionProviders.get(qName);
    }

    public static void addExtensionProvider(String string, String string2, Object object) {
        ProviderManager.validate(string, string2);
        QName qName = ProviderManager.removeExtensionProvider(string, string2);
        if (!(object instanceof ExtensionElementProvider)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider");
        }
        extensionProviders.put(qName, (ExtensionElementProvider)object);
    }

    public static QName removeExtensionProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        extensionProviders.remove(qName);
        return qName;
    }

    public static List<ExtensionElementProvider<ExtensionElement>> getExtensionProviders() {
        ArrayList<ExtensionElementProvider<ExtensionElement>> arrayList = new ArrayList<ExtensionElementProvider<ExtensionElement>>(extensionProviders.size());
        arrayList.addAll(extensionProviders.values());
        return arrayList;
    }

    public static ExtensionElementProvider<ExtensionElement> getStreamFeatureProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        return streamFeatureProviders.get(qName);
    }

    public static void addStreamFeatureProvider(String string, String string2, ExtensionElementProvider<ExtensionElement> extensionElementProvider) {
        ProviderManager.validate(string, string2);
        QName qName = ProviderManager.getQName(string, string2);
        streamFeatureProviders.put(qName, extensionElementProvider);
    }

    public static void removeStreamFeatureProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        streamFeatureProviders.remove(qName);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        return ProviderManager.getNonzaProvider(qName);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(QName qName) {
        return nonzaProviders.get(qName);
    }

    public static void addNonzaProvider(NonzaProvider<? extends Nonza> nonzaProvider) {
        Class clazz = nonzaProvider.getElementClass();
        QName qName = XmppElementUtil.getQNameFor(clazz);
        nonzaProviders.put(qName, nonzaProvider);
    }

    public static void removeNonzaProvider(Class<? extends Nonza> clazz) {
        QName qName = XmppElementUtil.getQNameFor(clazz);
        nonzaProviders.remove(qName);
    }

    public static void removeNonzaProvider(String string, String string2) {
        QName qName = ProviderManager.getQName(string, string2);
        nonzaProviders.remove(qName);
    }

    private static QName getQName(String string, String string2) {
        return new QName(string2, string);
    }

    private static void validate(String string, String string2) {
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("elementName must not be null or empty");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
    }

    static {
        Smack.ensureInitialized();
    }
}

