/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.util.stringencoder.Base64;

class HTTPProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    HTTPProxySocketConnection(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    @Override
    public void connect(Socket socket, String string, int n, int n2) {
        Object object;
        String string2;
        String string3 = this.proxy.getProxyAddress();
        int n3 = this.proxy.getProxyPort();
        socket.connect(new InetSocketAddress(string3, n3));
        String string4 = "CONNECT " + string + ":" + n;
        String string5 = this.proxy.getProxyUsername();
        if (string5 == null) {
            string2 = "";
        } else {
            object = this.proxy.getProxyPassword();
            string2 = "\r\nProxy-Authorization: Basic " + Base64.encode(string5 + ":" + (String)object);
        }
        socket.getOutputStream().write((string4 + " HTTP/1.1\r\nHost: " + string + ":" + n + string2 + "\r\n\r\n").getBytes("UTF-8"));
        object = socket.getInputStream();
        StringBuilder stringBuilder = new StringBuilder(100);
        int n4 = 0;
        do {
            int n5;
            if ((n5 = ((InputStream)object).read()) == -1) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            char c2 = (char)n5;
            stringBuilder.append(c2);
            if (stringBuilder.length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Received header of >1024 characters from " + string3 + ", cancelling connection");
            }
            if ((n4 == 0 || n4 == 2) && c2 == '\r') {
                ++n4;
                continue;
            }
            if ((n4 == 1 || n4 == 3) && c2 == '\n') {
                ++n4;
                continue;
            }
            n4 = 0;
        } while (n4 != 4);
        if (n4 != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + string3 + ", cancelling connection");
        }
        String string6 = stringBuilder.toString();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string6));
        String string7 = bufferedReader.readLine();
        if (string7 == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + string3 + ", cancelling");
        }
        Matcher matcher = RESPONSE_PATTERN.matcher(string7);
        if (!matcher.matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + string3 + ": " + string7);
        }
        int n6 = Integer.parseInt(matcher.group(1));
        if (n6 != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Error code in proxy response: " + n6);
        }
    }
}

