/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum SASLError {
    aborted,
    account_disabled,
    credentials_expired,
    encryption_required,
    incorrect_encoding,
    invalid_authzid,
    invalid_mechanism,
    malformed_request,
    mechanism_too_weak,
    not_authorized,
    temporary_auth_failure;

    private static final Logger LOGGER;

    public String toString() {
        return this.name().replace('_', '-');
    }

    public static SASLError fromString(String string) {
        string = string.replace('-', '_');
        SASLError sASLError = null;
        try {
            sASLError = SASLError.valueOf(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Could not transform string '" + string + "' to SASLError", exception);
        }
        return sASLError;
    }

    static {
        LOGGER = Logger.getLogger(SASLError.class.getName());
    }
}

