/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> Collection<T> requireNotEmpty(Collection<T> collection, String string) {
        if (collection == null) {
            throw new NullPointerException(string + " must not be null.");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(string + " must not be empty.");
        }
        return collection;
    }

    public static <T, C extends Collection<T>> List<T> removeUntil(C c2, Predicate<T> predicate) {
        T t;
        ArrayList<T> arrayList = new ArrayList<T>(c2.size());
        Iterator<T> iterator = c2.iterator();
        while (iterator.hasNext() && !predicate.test(t = iterator.next())) {
            arrayList.add(t);
            iterator.remove();
        }
        return arrayList;
    }

    public static <T> ArrayList<T> newListWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> cloneAndSeal(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<? extends T> arrayList = CollectionUtil.newListWith(collection);
        return Collections.unmodifiableList(arrayList);
    }

    public static <K, V> Map<K, V> cloneAndSeal(Map<K, V> map) {
        HashMap<K, V> hashMap = new HashMap<K, V>(map);
        return Collections.unmodifiableMap(hashMap);
    }

    public static <T> Set<T> newSetWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new HashSet<T>(collection);
    }

    public static <T> List<T> emptyOrSingletonListFrom(T t) {
        if (t == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(t);
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

