/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.UnparsedIQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser getParserFor(String string) {
        return PacketParserUtils.getParserFor(new StringReader(string));
    }

    public static XmlPullParser getParserFor(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return SmackXmlParser.newXmlParser((Reader)inputStreamReader);
    }

    public static XmlPullParser getParserFor(Reader reader) {
        XmlPullParser xmlPullParser = SmackXmlParser.newXmlParser((Reader)reader);
        ParserUtils.forwardToStartElement(xmlPullParser);
        return xmlPullParser;
    }

    public static <S extends Stanza> S parseStanza(String string) {
        return (S)PacketParserUtils.parseStanza(PacketParserUtils.getParserFor(string), XmlEnvironment.EMPTY);
    }

    public static Stanza parseStanza(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        String string;
        ParserUtils.assertAtStartTag(xmlPullParser);
        switch (string = xmlPullParser.getName()) {
            case "message": {
                return PacketParserUtils.parseMessage(xmlPullParser, xmlEnvironment);
            }
            case "iq": {
                return PacketParserUtils.parseIQ(xmlPullParser, xmlEnvironment);
            }
            case "presence": {
                return PacketParserUtils.parsePresence(xmlPullParser, xmlEnvironment);
            }
        }
        throw new IllegalArgumentException("Can only parse message, iq or presence, not " + string);
    }

    private static <SB extends StanzaBuilder<?>> SB parseCommonStanzaAttributes(StanzaBuilderSupplier<SB> stanzaBuilderSupplier, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        String string = xmlPullParser.getAttributeValue("id");
        SB SB = stanzaBuilderSupplier.get(string);
        i i2 = ParserUtils.getJidAttribute(xmlPullParser, "to");
        ((StanzaBuilder)SB).to(i2);
        i i3 = ParserUtils.getJidAttribute(xmlPullParser, "from");
        ((StanzaBuilder)SB).from(i3);
        String string2 = ParserUtils.getXmlLang(xmlPullParser, xmlEnvironment);
        ((StanzaBuilder)SB).setLanguage(string2);
        return SB;
    }

    public static Message parseMessage(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseMessage(xmlPullParser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Message parseMessage(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (xmlPullParser.getName().equals("message"));
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        int n = xmlPullParser.getDepth();
        MessageBuilder messageBuilder = PacketParserUtils.parseCommonStanzaAttributes(string -> StanzaBuilder.buildMessage(string), xmlPullParser, xmlEnvironment);
        String string2 = xmlPullParser.getAttributeValue("", "type");
        if (string2 != null) {
            messageBuilder.ofType(Message.Type.fromString(string2));
        }
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string3 = xmlPullParser.getName();
                    String string4 = xmlPullParser.getNamespace();
                    switch (string3) {
                        case "error": {
                            messageBuilder.setError(PacketParserUtils.parseError(xmlPullParser, xmlEnvironment2));
                            break block0;
                        }
                    }
                    ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(string3, string4, xmlPullParser, xmlEnvironment2);
                    messageBuilder.addExtension(extensionElement);
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return messageBuilder.build();
                }
            }
        }
    }

    public static String parseElementText(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        XmlPullParser.Event event = xmlPullParser.next();
        if (event != XmlPullParser.Event.TEXT_CHARACTERS) {
            if (event == XmlPullParser.Event.END_ELEMENT) {
                return "";
            }
            throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
        }
        String string = xmlPullParser.getText();
        event = xmlPullParser.next();
        if (event != XmlPullParser.Event.END_ELEMENT) {
            throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
        }
        return string;
    }

    public static CharSequence parseElement(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseElement(xmlPullParser, false);
    }

    public static CharSequence parseElement(XmlPullParser xmlPullParser, boolean bl) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        return PacketParserUtils.parseContentDepth(xmlPullParser, xmlPullParser.getDepth(), bl);
    }

    public static CharSequence parseContentDepth(XmlPullParser xmlPullParser, int n) {
        return PacketParserUtils.parseContentDepth(xmlPullParser, n, false);
    }

    public static CharSequence parseContentDepth(XmlPullParser xmlPullParser, int n, boolean bl) {
        if (xmlPullParser.supportsRoundtrip()) {
            return PacketParserUtils.parseContentDepthWithRoundtrip(xmlPullParser, n);
        }
        return PacketParserUtils.parseContentDepthWithoutRoundtrip(xmlPullParser, n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CharSequence parseContentDepthWithoutRoundtrip(XmlPullParser xmlPullParser, int n, boolean bl) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        XmlPullParser.Event event = xmlPullParser.getEventType();
        String string = null;
        boolean bl2 = false;
        while (true) {
            switch (event) {
                case START_ELEMENT: {
                    String string2;
                    if (bl2) {
                        xmlStringBuilder.rightAngleBracket();
                    } else {
                        bl2 = true;
                    }
                    xmlStringBuilder.halfOpenElement(xmlPullParser.getName());
                    if ((string == null || bl) && StringUtils.isNotEmpty((CharSequence)(string2 = xmlPullParser.getNamespace()))) {
                        xmlStringBuilder.attribute("xmlns", string2);
                        string = xmlPullParser.getName();
                    }
                    for (int k = 0; k < xmlPullParser.getAttributeCount(); ++k) {
                        xmlStringBuilder.attribute(xmlPullParser.getAttributeName(k), xmlPullParser.getAttributeValue(k));
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (bl2) {
                        xmlStringBuilder.closeEmptyElement();
                        bl2 = false;
                    } else {
                        xmlStringBuilder.closeElement(xmlPullParser.getName());
                    }
                    if (string != null && string.equals(xmlPullParser.getName())) {
                        string = null;
                    }
                    if (xmlPullParser.getDepth() > n) break;
                    return xmlStringBuilder;
                }
                case TEXT_CHARACTERS: {
                    if (bl2) {
                        bl2 = false;
                        xmlStringBuilder.rightAngleBracket();
                    }
                    xmlStringBuilder.escape(xmlPullParser.getText());
                }
            }
            event = xmlPullParser.next();
        }
    }

    private static XmlStringBuilder parseContentDepthWithRoundtrip(XmlPullParser xmlPullParser, int n) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        XmlPullParser.Event event = xmlPullParser.getEventType();
        boolean bl = false;
        block4: while (true) {
            switch (event) {
                case START_ELEMENT: {
                    bl = true;
                    String string = xmlPullParser.getText();
                    xmlStringBuilder.append(string);
                    break;
                }
                case END_ELEMENT: {
                    CharSequence charSequence;
                    boolean bl2 = false;
                    if (bl) {
                        bl2 = true;
                        bl = false;
                    }
                    if (!bl2) {
                        charSequence = xmlPullParser.getText();
                        xmlStringBuilder.append(charSequence);
                    }
                    if (xmlPullParser.getDepth() > n) break;
                    break block4;
                }
                default: {
                    bl = false;
                    CharSequence charSequence = xmlPullParser.getText();
                    if (event == XmlPullParser.Event.TEXT_CHARACTERS) {
                        charSequence = StringUtils.escapeForXml(charSequence);
                    }
                    xmlStringBuilder.append(charSequence);
                }
            }
            event = xmlPullParser.next();
        }
        return xmlStringBuilder;
    }

    public static Presence parsePresence(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parsePresence(xmlPullParser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Presence parsePresence(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        PresenceBuilder presenceBuilder = PacketParserUtils.parseCommonStanzaAttributes(string -> StanzaBuilder.buildPresence(string), xmlPullParser, xmlEnvironment);
        Presence.Type type = Presence.Type.available;
        String string2 = xmlPullParser.getAttributeValue("", "type");
        if (string2 != null && !string2.equals("")) {
            type = Presence.Type.fromString(string2);
        }
        presenceBuilder.ofType(type);
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block1 : switch (event) {
                case START_ELEMENT: {
                    String string3 = xmlPullParser.getName();
                    String string4 = xmlPullParser.getNamespace();
                    switch (string3) {
                        case "status": {
                            presenceBuilder.setStatus(xmlPullParser.nextText());
                            break block1;
                        }
                        case "priority": {
                            Byte by = ParserUtils.getByteAttributeFromNextText(xmlPullParser);
                            presenceBuilder.setPriority(by);
                            break block1;
                        }
                        case "show": {
                            String string5 = xmlPullParser.nextText();
                            if (StringUtils.isNotEmpty((CharSequence)string5)) {
                                presenceBuilder.setMode(Presence.Mode.fromString(string5));
                                break block1;
                            }
                            LOGGER.warning("Empty or null mode text in presence show element form " + presenceBuilder + "' which is invalid according to RFC6121 4.7.2.1");
                            break block1;
                        }
                        case "error": {
                            presenceBuilder.setError(PacketParserUtils.parseError(xmlPullParser, xmlEnvironment2));
                            break block1;
                        }
                    }
                    try {
                        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(string3, string4, xmlPullParser, xmlEnvironment2);
                        presenceBuilder.addExtension(extensionElement);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Failed to parse extension element in Presence stanza: " + presenceBuilder, exception);
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return presenceBuilder.build();
                }
            }
        }
    }

    public static IQ parseIQ(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseIQ(xmlPullParser, null);
    }

    public static IqData parseIqData(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue("", "id");
        IqData iqData = StanzaBuilder.buildIqData(string);
        i i2 = ParserUtils.getJidAttribute(xmlPullParser, "to");
        iqData.to(i2);
        i i3 = ParserUtils.getJidAttribute(xmlPullParser, "from");
        iqData.from(i3);
        String string2 = xmlPullParser.getAttributeValue("", "type");
        IQ.Type type = IQ.Type.fromString(string2);
        iqData.ofType(type);
        return iqData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IQ parseIQ(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        Stanza stanza = null;
        StanzaError stanzaError = null;
        IqData iqData = PacketParserUtils.parseIqData(xmlPullParser);
        block14: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string = xmlPullParser.getName();
                    String string2 = xmlPullParser.getNamespace();
                    switch (string) {
                        case "error": {
                            stanzaError = PacketParserUtils.parseError(xmlPullParser, xmlEnvironment2);
                            break block0;
                        }
                    }
                    IqProvider<IQ> iqProvider = ProviderManager.getIQProvider(string, string2);
                    if (iqProvider != null) {
                        stanza = iqProvider.parse(xmlPullParser, iqData, xmlEnvironment);
                        break;
                    }
                    stanza = new UnparsedIQ(string, string2, PacketParserUtils.parseElement(xmlPullParser));
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block14;
                }
            }
        }
        if (stanza == null) {
            switch (iqData.getType()) {
                case error: {
                    return ErrorIQ.builder(stanzaError, iqData).build();
                }
                case result: {
                    stanza = new EmptyResultIQ();
                    break;
                }
            }
        }
        stanza.setStanzaId(iqData.getStanzaId());
        stanza.setTo(iqData.getTo());
        stanza.setFrom(iqData.getFrom());
        ((IQ)stanza).setType(iqData.getType());
        stanza.setError(stanzaError);
        return stanza;
    }

    public static Collection<String> parseMechanisms(XmlPullParser xmlPullParser) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            XmlPullParser.Event event = xmlPullParser.next();
            if (event == XmlPullParser.Event.START_ELEMENT) {
                String string = xmlPullParser.getName();
                if (!string.equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Compress.Feature parseCompressionFeature(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        int n = xmlPullParser.getDepth();
        LinkedList<String> linkedList = new LinkedList<String>();
        block16: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "method": {
                            linkedList.add(xmlPullParser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "compression": {
                            if (xmlPullParser.getDepth() == n) break block16;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
            }
        }
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.END_ELEMENT);
        assert (xmlPullParser.getDepth() == n);
        return new Compress.Feature(linkedList);
    }

    public static Map<String, String> parseDescriptiveTexts(XmlPullParser xmlPullParser, Map<String, String> map) {
        String string;
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if ((string = ParserUtils.getXmlLang(xmlPullParser)) == null) {
            string = "";
        }
        String string2 = xmlPullParser.nextText();
        String string3 = map.put(string, string2);
        assert (string3 == null);
        return map;
    }

    public static StreamError parseStreamError(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseStreamError(xmlPullParser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamError parseStreamError(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        int n = xmlPullParser.getDepth();
        ArrayList<ExtensionElement> arrayList = new ArrayList<ExtensionElement>();
        Map<String, String> map = null;
        StreamError.Condition condition = null;
        String string = null;
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            switch (event) {
                case START_ELEMENT: {
                    String string2;
                    String string3 = xmlPullParser.getName();
                    block7 : switch (string2 = xmlPullParser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-streams": {
                            switch (string3) {
                                case "text": {
                                    map = PacketParserUtils.parseDescriptiveTexts(xmlPullParser, map);
                                    break block7;
                                }
                            }
                            condition = StreamError.Condition.fromString(string3);
                            string = xmlPullParser.nextText();
                            if (!string.isEmpty()) break;
                            string = null;
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(arrayList, xmlPullParser, string3, string2, xmlEnvironment2);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return new StreamError(condition, string, map, arrayList);
                }
            }
        }
    }

    public static StanzaError parseError(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseError(xmlPullParser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StanzaError parseError(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        int n = xmlPullParser.getDepth();
        Map<String, String> map = null;
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        ArrayList<ExtensionElement> arrayList = new ArrayList<ExtensionElement>();
        StanzaError.Builder builder = StanzaError.getBuilder();
        builder.setType(StanzaError.Type.fromString(xmlPullParser.getAttributeValue("", "type")));
        builder.setErrorGenerator(xmlPullParser.getAttributeValue("", "by"));
        block16: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            switch (event) {
                case START_ELEMENT: {
                    String string;
                    String string2 = xmlPullParser.getName();
                    block7 : switch (string = xmlPullParser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-stanzas": {
                            switch (string2) {
                                case "text": {
                                    map = PacketParserUtils.parseDescriptiveTexts(xmlPullParser, map);
                                    break block7;
                                }
                            }
                            builder.setCondition(StanzaError.Condition.fromString(string2));
                            String string3 = xmlPullParser.nextText();
                            if (string3.isEmpty()) break;
                            builder.setConditionText(string3);
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(arrayList, xmlPullParser, string2, string, xmlEnvironment2);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block16;
                }
            }
        }
        ((StanzaError.Builder)builder.setExtensions(arrayList)).setDescriptiveTexts(map);
        return builder.build();
    }

    public static ExtensionElement parseExtensionElement(String string, String string2, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        ExtensionElementProvider<ExtensionElement> extensionElementProvider = ProviderManager.getExtensionProvider(string, string2);
        if (extensionElementProvider != null) {
            return (ExtensionElement)extensionElementProvider.parse(xmlPullParser, xmlEnvironment);
        }
        return (ExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(xmlPullParser, xmlEnvironment);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StartTls parseStartTlsFeature(XmlPullParser xmlPullParser) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (xmlPullParser.getNamespace().equals("urn:ietf:params:xml:ns:xmpp-tls"));
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        block10: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "required": {
                            bl = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag(xmlPullParser);
        return new StartTls(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Session.Feature parseSessionFeature(XmlPullParser xmlPullParser) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "optional": {
                            bl = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return new Session.Feature(bl);
                }
            }
        }
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        PacketParserUtils.addExtensionElement(stanzaBuilder, xmlPullParser, xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser xmlPullParser, String string, String string2, XmlEnvironment xmlEnvironment) {
        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(string, string2, xmlPullParser, xmlEnvironment);
        stanzaBuilder.addExtension(extensionElement);
    }

    public static void addExtensionElement(Stanza stanza, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        PacketParserUtils.addExtensionElement(stanza, xmlPullParser, xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(Stanza stanza, XmlPullParser xmlPullParser, String string, String string2, XmlEnvironment xmlEnvironment) {
        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(string, string2, xmlPullParser, xmlEnvironment);
        stanza.addExtension(extensionElement);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        PacketParserUtils.addExtensionElement(collection, xmlPullParser, xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser xmlPullParser, String string, String string2, XmlEnvironment xmlEnvironment) {
        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(string, string2, xmlPullParser, xmlEnvironment);
        collection.add(extensionElement);
    }

    private static interface StanzaBuilderSupplier<SB extends StanzaBuilder<?>> {
        public SB get(String var1);
    }
}

