/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.e.a.a.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.e.a.i;
import org.e.c.c;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class ParserUtils {
    public static final String JID = "jid";

    public static void assertAtStartTag(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
    }

    public static void assertAtStartTag(XmlPullParser xmlPullParser, String string) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (string.equals(xmlPullParser.getName()));
    }

    public static void assertAtEndTag(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.END_ELEMENT);
    }

    public static void forwardToStartElement(XmlPullParser xmlPullParser) {
        XmlPullParser.Event event = xmlPullParser.getEventType();
        while (event != XmlPullParser.Event.START_ELEMENT) {
            if (event == XmlPullParser.Event.END_DOCUMENT) {
                throw new IllegalArgumentException("Document contains no start tag");
            }
            event = xmlPullParser.next();
        }
    }

    public static void forwardToEndTagOfDepth(XmlPullParser xmlPullParser, int n) {
        XmlPullParser.Event event = xmlPullParser.getEventType();
        while (event != XmlPullParser.Event.END_ELEMENT || xmlPullParser.getDepth() != n) {
            assert (event != XmlPullParser.Event.END_DOCUMENT);
            event = xmlPullParser.next();
        }
    }

    public static i getJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getJidAttribute(xmlPullParser, JID);
    }

    public static i getJidAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return d.a((String)string2);
    }

    public static e getBareJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getBareJidAttribute(xmlPullParser, JID);
    }

    public static e getBareJidAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return d.c((String)string2);
    }

    public static f getFullJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getFullJidAttribute(xmlPullParser, JID);
    }

    public static f getFullJidAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return d.d((String)string2);
    }

    public static g getEntityJidAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        i i2 = d.a((String)string2);
        if (!i2.m()) {
            return null;
        }
        f f2 = i2.q();
        if (f2 != null) {
            return f2;
        }
        e e2 = i2.o();
        return e2;
    }

    public static org.e.a.b.d getResourcepartAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return org.e.a.b.d.b((String)string2);
    }

    public static boolean parseXmlBoolean(String string) {
        switch (string) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        throw new IllegalArgumentException(string + " is not a valid boolean string");
    }

    public static Boolean getBooleanAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        string2 = string2.toLowerCase(Locale.US);
        return ParserUtils.parseXmlBoolean(string2);
    }

    public static boolean getBooleanAttribute(XmlPullParser xmlPullParser, String string, boolean bl) {
        Boolean bl2 = ParserUtils.getBooleanAttribute(xmlPullParser, string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public static Byte getByteAttributeFromNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        return Byte.valueOf(string);
    }

    public static int getIntegerAttributeOrThrow(XmlPullParser xmlPullParser, String string, String string2) {
        Integer n = ParserUtils.getIntegerAttribute(xmlPullParser, string);
        if (n == null) {
            throw new IOException(string2);
        }
        return n;
    }

    public static Integer getIntegerAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return Integer.valueOf(string2);
    }

    public static int getIntegerAttribute(XmlPullParser xmlPullParser, String string, int n) {
        Integer n2 = ParserUtils.getIntegerAttribute(xmlPullParser, string);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public static UInt16 getUInt16Attribute(XmlPullParser xmlPullParser, String string) {
        Integer n = ParserUtils.getIntegerAttribute(xmlPullParser, string);
        if (n == null) {
            return null;
        }
        return UInt16.from(n);
    }

    public static UInt16 getRequiredUInt16Attribute(XmlPullParser xmlPullParser, String string) {
        UInt16 uInt16 = ParserUtils.getUInt16Attribute(xmlPullParser, string);
        if (uInt16 == null) {
            throw new SmackParsingException.RequiredAttributeMissingException(string);
        }
        return uInt16;
    }

    public static int getIntegerFromNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        return Integer.valueOf(string);
    }

    public static Long getLongAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return Long.valueOf(string2);
    }

    public static long getLongAttribute(XmlPullParser xmlPullParser, String string, long l) {
        Long l2 = ParserUtils.getLongAttribute(xmlPullParser, string);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public static UInt32 getUInt32Attribute(XmlPullParser xmlPullParser, String string) {
        Long l = ParserUtils.getLongAttribute(xmlPullParser, string);
        if (l == null) {
            return null;
        }
        return UInt32.from(l);
    }

    public static double getDoubleFromNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        return Double.valueOf(string);
    }

    public static Double getDoubleAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return Double.valueOf(string2);
    }

    public static double getDoubleAttribute(XmlPullParser xmlPullParser, String string, long l) {
        Double d2 = ParserUtils.getDoubleAttribute(xmlPullParser, string);
        if (d2 == null) {
            return l;
        }
        return d2;
    }

    public static Short getShortAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (string2 == null) {
            return null;
        }
        return Short.valueOf(string2);
    }

    public static short getShortAttribute(XmlPullParser xmlPullParser, String string, short s) {
        Short s2 = ParserUtils.getShortAttribute(xmlPullParser, string);
        if (s2 == null) {
            return s;
        }
        return s2;
    }

    public static Date getDateFromOptionalXep82String(String string) {
        if (string == null) {
            return null;
        }
        return ParserUtils.getDateFromXep82String(string);
    }

    public static Date getDateFromXep82String(String string) {
        try {
            return c.a((String)string);
        }
        catch (ParseException parseException) {
            throw new SmackParsingException.SmackTextParseException(parseException);
        }
    }

    public static Date getDateFromString(String string) {
        try {
            return c.b((String)string);
        }
        catch (ParseException parseException) {
            throw new SmackParsingException.SmackTextParseException(parseException);
        }
    }

    public static Date getDateFromNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        return ParserUtils.getDateFromString(string);
    }

    public static URI getUriFromNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SmackParsingException.SmackUriSyntaxParsingException(uRISyntaxException);
        }
    }

    public static String getRequiredAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue("", string);
        if (StringUtils.isNullOrEmpty((CharSequence)string2)) {
            throw new IOException("Attribute " + string + " is null or empty (" + string2 + ')');
        }
        return string2;
    }

    public static String getRequiredNextText(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            throw new IOException("Next text is null or empty (" + string + ')');
        }
        return string;
    }

    public static String getXmlLang(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        String string = ParserUtils.getXmlLang(xmlPullParser);
        if (string != null) {
            return string;
        }
        return xmlEnvironment.getEffectiveLanguage();
    }

    public static String getXmlLang(XmlPullParser xmlPullParser) {
        return xmlPullParser.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
    }

    @Deprecated
    public static QName getQName(XmlPullParser xmlPullParser) {
        return xmlPullParser.getQName();
    }

    public static InternetAddress getInternetAddressIngoringZoneIdAttribute(XmlPullParser xmlPullParser, String string) {
        String string2 = xmlPullParser.getAttributeValue(string);
        if (string2 == null) {
            return null;
        }
        return InternetAddress.fromIgnoringZoneId(string2);
    }
}

