/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smack.util.SHA1;

public class StringUtils {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    @Deprecated
    public static final String UTF8 = "UTF-8";
    @Deprecated
    public static final String USASCII = "US-ASCII";
    public static final String QUOTE_ENCODE = "&quot;";
    public static final String APOS_ENCODE = "&apos;";
    public static final String AMP_ENCODE = "&amp;";
    public static final String LT_ENCODE = "&lt;";
    public static final String GT_ENCODE = "&gt;";
    public static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    public static final String UNAMBIGUOUS_NUMBERS_AND_LETTERS_STRING = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ";
    private static final char[] UNAMBIGUOUS_NUMBERS_AND_LETTERS = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ".toCharArray();
    private static final int RANDOM_STRING_CHUNK_SIZE = 4;
    private static final Pattern XML_WHITESPACE = Pattern.compile("[\t\n\r ]");
    public static final String PORTABLE_NEWLINE_REGEX = "\\r?\\n";

    public static CharSequence escapeForXml(CharSequence charSequence) {
        return StringUtils.escapeForXml(charSequence, XmlEscapeMode.safe);
    }

    public static CharSequence escapeForXmlAttribute(CharSequence charSequence) {
        return StringUtils.escapeForXml(charSequence, XmlEscapeMode.forAttribute);
    }

    public static CharSequence escapeForXmlAttributeApos(CharSequence charSequence) {
        return StringUtils.escapeForXml(charSequence, XmlEscapeMode.forAttributeApos);
    }

    public static CharSequence escapeForXmlText(CharSequence charSequence) {
        return StringUtils.escapeForXml(charSequence, XmlEscapeMode.forText);
    }

    private static CharSequence escapeForXml(CharSequence charSequence, XmlEscapeMode xmlEscapeMode) {
        if (charSequence == null) {
            return null;
        }
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.3));
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = null;
            char c2 = charSequence.charAt(n3);
            block0 : switch (xmlEscapeMode) {
                case safe: {
                    switch (c2) {
                        case '<': {
                            string = LT_ENCODE;
                            break block0;
                        }
                        case '>': {
                            string = GT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            string = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            string = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            string = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forAttribute: {
                    switch (c2) {
                        case '<': {
                            string = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            string = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            string = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            string = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forAttributeApos: {
                    switch (c2) {
                        case '<': {
                            string = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            string = AMP_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            string = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forText: {
                    switch (c2) {
                        case '<': {
                            string = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            string = AMP_ENCODE;
                            break block0;
                        }
                    }
                }
            }
            if (string != null) {
                if (n3 > n2) {
                    stringBuilder.append(charSequence, n2, n3);
                }
                stringBuilder.append((CharSequence)string);
                n2 = ++n3;
                continue;
            }
            ++n3;
        }
        if (n2 == 0) {
            return charSequence;
        }
        if (n3 > n2) {
            stringBuilder.append(charSequence, n2, n3);
        }
        return stringBuilder;
    }

    @Deprecated
    public static synchronized String hash(String string) {
        return org.jivesoftware.smack.util.SHA1.hex(string);
    }

    public static String encodeHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int k = 0; k < byArray.length; ++k) {
            int n = byArray[k] & 0xFF;
            cArray[k * 2] = HEX_CHARS[n >>> 4];
            cArray[k * 2 + 1] = HEX_CHARS[n & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] toUtf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String insecureRandomString(int n) {
        return StringUtils.randomString(n, RandomUtil.RANDOM.get());
    }

    public static String secureOnlineAttackSafeRandomString() {
        int n = 10;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 10);
    }

    public static String secureUniqueRandomString() {
        int n = 13;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 13);
    }

    public static String secureOfflineAttackSafeRandomString() {
        int n = 24;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 24);
    }

    private static String randomString(Random random, char[] cArray, int n) {
        int n2 = n + (n - 1) / 4;
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        try {
            StringUtils.randomString(charBuffer, random, cArray, n);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return charBuffer.flip().toString();
    }

    private static void randomString(Appendable appendable, Random random, char[] cArray, int n) {
        for (int k = 1; k <= n; ++k) {
            int n2 = random.nextInt(cArray.length);
            char c2 = cArray[n2];
            appendable.append(c2);
            if (k % 4 != 0 || k >= n) continue;
            appendable.append('-');
        }
    }

    public static String randomString(int n) {
        return StringUtils.randomString(n, RandomUtil.SECURE_RANDOM.get());
    }

    public static String randomString(int n, Random random) {
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        for (int k = 0; k < n; ++k) {
            int n2 = random.nextInt(UNAMBIGUOUS_NUMBERS_AND_LETTERS.length);
            cArray[k] = UNAMBIGUOUS_NUMBERS_AND_LETTERS[n2];
        }
        return new String(cArray);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringUtils.isNullOrEmpty(charSequence);
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || StringUtils.isEmpty(charSequence);
    }

    public static boolean isNotEmpty(CharSequence ... charSequenceArray) {
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNullOrEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(CharSequence ... charSequenceArray) {
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrNotEmpty(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        return !charSequence.toString().isEmpty();
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence.length() == 0;
    }

    public static String collectionToString(Collection<? extends Object> collection) {
        return StringUtils.toStringBuilder(collection, " ").toString();
    }

    public static StringBuilder toStringBuilder(Collection<? extends Object> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 20);
        StringUtils.appendTo(collection, string, stringBuilder);
        return stringBuilder;
    }

    public static void appendTo(Collection<? extends Object> collection, StringBuilder stringBuilder) {
        StringUtils.appendTo(collection, ", ", stringBuilder);
    }

    public static <O> void appendTo(Collection<O> collection, StringBuilder stringBuilder, Consumer<O> consumer) {
        StringUtils.appendTo(collection, ", ", stringBuilder, consumer);
    }

    public static void appendTo(Collection<? extends Object> collection, String string, StringBuilder stringBuilder) {
        StringUtils.appendTo(collection, string, stringBuilder, object -> stringBuilder.append(object));
    }

    public static <O> void appendTo(Collection<O> collection, String string, StringBuilder stringBuilder, Consumer<O> consumer) {
        Iterator<O> iterator = collection.iterator();
        while (iterator.hasNext()) {
            O o = iterator.next();
            consumer.accept(o);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
    }

    public static String returnIfNotEmptyTrimmed(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public static boolean nullSafeCharSequenceEquals(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.nullSafeCharSequenceComparator(charSequence, charSequence2) == 0;
    }

    public static int nullSafeCharSequenceComparator(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null ^ charSequence2 == null) {
            return charSequence == null ? -1 : 1;
        }
        if (charSequence == null && charSequence2 == null) {
            return 0;
        }
        return charSequence.toString().compareTo(charSequence2.toString());
    }

    @Deprecated
    public static <CS extends CharSequence> CS requireNotNullOrEmpty(CS CS, String string) {
        return StringUtils.requireNotNullNorEmpty(CS, string);
    }

    public static <CS extends CharSequence> CS requireNotNullNorEmpty(CS CS, String string) {
        if (StringUtils.isNullOrEmpty(CS)) {
            throw new IllegalArgumentException(string);
        }
        return CS;
    }

    public static <CS extends CharSequence> CS requireNullOrNotEmpty(CS CS, String string) {
        if (CS == null) {
            return null;
        }
        if (StringUtils.isEmpty(CS)) {
            throw new IllegalArgumentException(string);
        }
        return CS;
    }

    public static String maybeToString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return charSequence.toString();
    }

    public static String deleteXmlWhitespace(String string) {
        return XML_WHITESPACE.matcher(string).replaceAll("");
    }

    public static Appendable appendHeading(Appendable appendable, String string) {
        return StringUtils.appendHeading(appendable, string, '-');
    }

    public static Appendable appendHeading(Appendable appendable, String string, char c2) {
        appendable.append(string).append('\n');
        for (int k = 0; k < string.length(); ++k) {
            appendable.append(c2);
        }
        return appendable.append('\n');
    }

    public static List<String> splitLinesPortable(String string) {
        String[] stringArray = string.split(PORTABLE_NEWLINE_REGEX);
        return Arrays.asList(stringArray);
    }

    public static List<String> toStrings(Collection<? extends CharSequence> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (CharSequence charSequence : collection) {
            String string = charSequence.toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    private static enum XmlEscapeMode {
        safe,
        forAttribute,
        forAttributeApos,
        forText;

    }
}

