/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.e.c.c;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.util.StringUtils;

public class XmlStringBuilder
implements Appendable,
CharSequence,
Element {
    public static final String RIGHT_ANGLE_BRACKET = Character.toString('>');
    private final LazyStringBuilder sb = new LazyStringBuilder();
    private final XmlEnvironment effectiveXmlEnvironment;

    public XmlStringBuilder() {
        this.effectiveXmlEnvironment = null;
    }

    public XmlStringBuilder(ExtensionElement extensionElement) {
        this(extensionElement, null);
    }

    public XmlStringBuilder(NamedElement namedElement) {
        this();
        this.halfOpenElement(namedElement.getElementName());
    }

    public XmlStringBuilder(FullyQualifiedElement fullyQualifiedElement, XmlEnvironment xmlEnvironment) {
        this(fullyQualifiedElement.getElementName(), fullyQualifiedElement.getNamespace(), fullyQualifiedElement.getLanguage(), xmlEnvironment);
    }

    public XmlStringBuilder(String string, String string2, String string3, XmlEnvironment xmlEnvironment) {
        this.halfOpenElement(string);
        if (xmlEnvironment == null) {
            this.xmlnsAttribute(string2);
            this.xmllangAttribute(string3);
        } else {
            if (!xmlEnvironment.effectiveNamespaceEquals(string2)) {
                this.xmlnsAttribute(string2);
            }
            if (!xmlEnvironment.effectiveLanguageEquals(string3)) {
                this.xmllangAttribute(string3);
            }
        }
        this.effectiveXmlEnvironment = XmlEnvironment.builder().withNamespace(string2).withLanguage(string3).withNext(xmlEnvironment).build();
    }

    public XmlEnvironment getXmlEnvironment() {
        return this.effectiveXmlEnvironment;
    }

    public XmlStringBuilder escapedElement(String string, String string2) {
        assert (string2 != null);
        this.openElement(string);
        this.append(string2);
        this.closeElement(string);
        return this;
    }

    public XmlStringBuilder element(String string, String string2) {
        if (string2.isEmpty()) {
            return this.emptyElement(string);
        }
        this.openElement(string);
        this.escape(string2);
        this.closeElement(string);
        return this;
    }

    public XmlStringBuilder element(String string, Date date) {
        assert (date != null);
        return this.element(string, c.a((Date)date));
    }

    public XmlStringBuilder element(String string, CharSequence charSequence) {
        return this.element(string, charSequence.toString());
    }

    public XmlStringBuilder element(String string, Enum<?> enum_) {
        assert (enum_ != null);
        this.element(string, enum_.toString());
        return this;
    }

    @Deprecated
    public XmlStringBuilder element(Element element) {
        assert (element != null);
        return this.append(element.toXML());
    }

    public XmlStringBuilder optElement(String string, String string2) {
        if (string2 != null) {
            this.element(string, string2);
        }
        return this;
    }

    public XmlStringBuilder optElement(String string, Date date) {
        if (date != null) {
            this.element(string, date);
        }
        return this;
    }

    public XmlStringBuilder optElement(String string, CharSequence charSequence) {
        if (charSequence != null) {
            this.element(string, charSequence.toString());
        }
        return this;
    }

    public XmlStringBuilder optElement(Element element) {
        if (element != null) {
            this.append(element);
        }
        return this;
    }

    public XmlStringBuilder optElement(String string, Enum<?> enum_) {
        if (enum_ != null) {
            this.element(string, enum_);
        }
        return this;
    }

    public XmlStringBuilder optElement(String string, Object object) {
        if (object != null) {
            this.element(string, object.toString());
        }
        return this;
    }

    public XmlStringBuilder optIntElement(String string, int n) {
        if (n >= 0) {
            this.element(string, String.valueOf(n));
        }
        return this;
    }

    public XmlStringBuilder halfOpenElement(String string) {
        assert (StringUtils.isNotEmpty((CharSequence)string));
        this.sb.append('<').append(string);
        return this;
    }

    public XmlStringBuilder halfOpenElement(NamedElement namedElement) {
        return this.halfOpenElement(namedElement.getElementName());
    }

    public XmlStringBuilder openElement(String string) {
        this.halfOpenElement(string).rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(String string) {
        this.sb.append("</").append(string);
        this.rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(NamedElement namedElement) {
        this.closeElement(namedElement.getElementName());
        return this;
    }

    public XmlStringBuilder closeEmptyElement() {
        this.sb.append("/>");
        return this;
    }

    public XmlStringBuilder rightAngleBracket() {
        this.sb.append(RIGHT_ANGLE_BRACKET);
        return this;
    }

    public XmlStringBuilder attribute(String string, String string2) {
        assert (string2 != null);
        this.sb.append(' ').append(string).append("='");
        this.escapeAttributeValue(string2);
        this.sb.append('\'');
        return this;
    }

    public XmlStringBuilder attribute(String string, boolean bl) {
        return this.attribute(string, Boolean.toString(bl));
    }

    public XmlStringBuilder attribute(String string, Date date) {
        assert (date != null);
        return this.attribute(string, c.a((Date)date));
    }

    public XmlStringBuilder attribute(String string, CharSequence charSequence) {
        return this.attribute(string, charSequence.toString());
    }

    public XmlStringBuilder attribute(String string, Enum<?> enum_) {
        assert (enum_ != null);
        this.attribute(string, enum_.toString());
        return this;
    }

    public <E extends Enum<?>> XmlStringBuilder attribute(String string, E e2, E e3) {
        if (e2 == null || e2 == e3) {
            return this;
        }
        this.attribute(string, e2.toString());
        return this;
    }

    public XmlStringBuilder attribute(String string, int n) {
        assert (string != null);
        return this.attribute(string, String.valueOf(n));
    }

    public XmlStringBuilder attribute(String string, long l) {
        assert (string != null);
        return this.attribute(string, String.valueOf(l));
    }

    public XmlStringBuilder optAttribute(String string, String string2) {
        if (string2 != null) {
            this.attribute(string, string2);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, Long l) {
        if (l != null) {
            this.attribute(string, l);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, Date date) {
        if (date != null) {
            this.attribute(string, date);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, CharSequence charSequence) {
        if (charSequence != null) {
            this.attribute(string, charSequence.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, Enum<?> enum_) {
        if (enum_ != null) {
            this.attribute(string, enum_.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, Number number) {
        if (number != null) {
            this.attribute(string, number.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttributeCs(String string, CharSequence charSequence) {
        return this.optAttribute(string, charSequence);
    }

    public XmlStringBuilder optIntAttribute(String string, int n) {
        if (n >= 0) {
            this.attribute(string, Integer.toString(n));
        }
        return this;
    }

    public XmlStringBuilder optIntAttribute(String string, Integer n) {
        if (n != null) {
            this.attribute(string, n.toString());
        }
        return this;
    }

    public XmlStringBuilder optLongAttribute(String string, Long l) {
        if (l != null && l >= 0L) {
            this.attribute(string, Long.toString(l));
        }
        return this;
    }

    public XmlStringBuilder optBooleanAttribute(String string, boolean bl) {
        if (bl) {
            this.sb.append(' ').append(string).append("='true'");
        }
        return this;
    }

    public XmlStringBuilder optBooleanAttributeDefaultTrue(String string, boolean bl) {
        if (!bl) {
            this.sb.append(' ').append(string).append("='false'");
        }
        return this;
    }

    public XmlStringBuilder xmlnsAttribute(String string) {
        if (string == null || this.effectiveXmlEnvironment != null && this.effectiveXmlEnvironment.effectiveNamespaceEquals(string)) {
            return this;
        }
        XmlNsAttribute xmlNsAttribute = new XmlNsAttribute(string);
        this.append(xmlNsAttribute);
        return this;
    }

    public XmlStringBuilder xmllangAttribute(String string) {
        this.optAttribute("xml:lang", string);
        return this;
    }

    public XmlStringBuilder optXmlLangAttribute(String string) {
        if (!StringUtils.isNullOrEmpty((CharSequence)string)) {
            this.xmllangAttribute(string);
        }
        return this;
    }

    public XmlStringBuilder text(CharSequence charSequence) {
        assert (charSequence != null);
        CharSequence charSequence2 = StringUtils.escapeForXmlText(charSequence);
        this.sb.append(charSequence2);
        return this;
    }

    public XmlStringBuilder escape(String string) {
        assert (string != null);
        this.sb.append(StringUtils.escapeForXml(string));
        return this;
    }

    public XmlStringBuilder escapeAttributeValue(String string) {
        assert (string != null);
        this.sb.append(StringUtils.escapeForXmlAttributeApos(string));
        return this;
    }

    public XmlStringBuilder optEscape(CharSequence charSequence) {
        if (charSequence == null) {
            return this;
        }
        return this.escape(charSequence);
    }

    public XmlStringBuilder escape(CharSequence charSequence) {
        return this.escape(charSequence.toString());
    }

    protected XmlStringBuilder prelude(FullyQualifiedElement fullyQualifiedElement) {
        return this.prelude(fullyQualifiedElement.getElementName(), fullyQualifiedElement.getNamespace());
    }

    protected XmlStringBuilder prelude(String string, String string2) {
        this.halfOpenElement(string);
        this.xmlnsAttribute(string2);
        return this;
    }

    public XmlStringBuilder optAppend(Element element) {
        if (element != null) {
            this.append(element.toXML(this.effectiveXmlEnvironment));
        }
        return this;
    }

    public XmlStringBuilder optAppend(Collection<? extends Element> collection) {
        if (collection != null) {
            this.append(collection);
        }
        return this;
    }

    public XmlStringBuilder optTextChild(CharSequence charSequence, NamedElement namedElement) {
        if (charSequence == null) {
            return this.closeEmptyElement();
        }
        this.rightAngleBracket();
        this.escape(charSequence);
        this.closeElement(namedElement);
        return this;
    }

    public XmlStringBuilder append(XmlStringBuilder xmlStringBuilder) {
        assert (xmlStringBuilder != null);
        this.sb.append(xmlStringBuilder.sb);
        return this;
    }

    public XmlStringBuilder append(Element element) {
        return this.append(element.toXML(this.effectiveXmlEnvironment));
    }

    public XmlStringBuilder append(Collection<? extends Element> collection) {
        for (Element element : collection) {
            this.append(element);
        }
        return this;
    }

    public XmlStringBuilder emptyElement(Enum<?> enum_) {
        return this.emptyElement(enum_.toString());
    }

    public XmlStringBuilder emptyElement(String string) {
        this.halfOpenElement(string);
        return this.closeEmptyElement();
    }

    public XmlStringBuilder condEmptyElement(boolean bl, String string) {
        if (bl) {
            this.emptyElement(string);
        }
        return this;
    }

    public XmlStringBuilder condAttribute(boolean bl, String string, String string2) {
        if (bl) {
            this.attribute(string, string2);
        }
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence charSequence) {
        assert (charSequence != null);
        this.sb.append(charSequence);
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence charSequence, int n, int n2) {
        assert (charSequence != null);
        this.sb.append(charSequence, n, n2);
        return this;
    }

    @Override
    public XmlStringBuilder append(char c2) {
        this.sb.append(c2);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int n) {
        return this.sb.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.sb.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharSequence)) {
            return false;
        }
        CharSequence charSequence = (CharSequence)object;
        return this.toString().equals(charSequence.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void write(Writer writer, XmlEnvironment xmlEnvironment) {
        try {
            this.appendXmlTo(charSequence -> {
                try {
                    writer.append((CharSequence)charSequence);
                }
                catch (IOException iOException) {
                    throw new WrappedIoException(iOException);
                }
            }, xmlEnvironment);
        }
        catch (WrappedIoException wrappedIoException) {
            throw wrappedIoException.wrappedIoException;
        }
    }

    public List<CharSequence> toList(XmlEnvironment xmlEnvironment) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.sb.getAsList().size());
        this.appendXmlTo(charSequence -> arrayList.add((CharSequence)charSequence), xmlEnvironment);
        return arrayList;
    }

    @Override
    public StringBuilder toXML(XmlEnvironment xmlEnvironment) {
        int n = this.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        this.appendXmlTo(charSequence -> stringBuilder.append((CharSequence)charSequence), xmlEnvironment);
        return stringBuilder;
    }

    private void appendXmlTo(Consumer<CharSequence> consumer, XmlEnvironment xmlEnvironment) {
        for (CharSequence charSequence : this.sb.getAsList()) {
            if (charSequence instanceof XmlStringBuilder) {
                ((XmlStringBuilder)charSequence).appendXmlTo(consumer, xmlEnvironment);
                continue;
            }
            if (charSequence instanceof XmlNsAttribute) {
                XmlNsAttribute xmlNsAttribute = (XmlNsAttribute)charSequence;
                if (xmlNsAttribute.value.equals(xmlEnvironment.getEffectiveNamespace())) continue;
                consumer.accept(xmlNsAttribute);
                xmlEnvironment = new XmlEnvironment(xmlNsAttribute.value);
                continue;
            }
            consumer.accept(charSequence);
        }
    }

    private static final class WrappedIoException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IOException wrappedIoException;

        private WrappedIoException(IOException iOException) {
            this.wrappedIoException = iOException;
        }
    }

    private static final class XmlNsAttribute
    implements CharSequence {
        private final String value;
        private final String xmlFragment;

        private XmlNsAttribute(String string) {
            this.value = StringUtils.requireNotNullNorEmpty(string, "Value must not be null");
            this.xmlFragment = " xmlns='" + string + '\'';
        }

        @Override
        public String toString() {
            return this.xmlFragment;
        }

        @Override
        public int length() {
            return this.xmlFragment.length();
        }

        @Override
        public char charAt(int n) {
            return this.xmlFragment.charAt(n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return this.xmlFragment.subSequence(n, n2);
        }
    }
}

