/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.rce;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.jivesoftware.smack.datatypes.UInt16;

public interface RemoteConnectionEndpoint {
    public CharSequence getHost();

    public UInt16 getPort();

    public Collection<? extends InetAddress> getInetAddresses();

    public String getDescription();

    public static class InetSocketAddressCoupling<RCE extends RemoteConnectionEndpoint> {
        private final RCE connectionEndpoint;
        private final InetSocketAddress inetSocketAddress;

        public InetSocketAddressCoupling(RCE RCE, InetAddress inetAddress) {
            this.connectionEndpoint = RCE;
            UInt16 uInt16 = RCE.getPort();
            this.inetSocketAddress = new InetSocketAddress(inetAddress, uInt16.intValue());
        }

        public RCE getRemoteConnectionEndpoint() {
            return this.connectionEndpoint;
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.inetSocketAddress;
        }

        public String toString() {
            return this.connectionEndpoint.getDescription() + " (" + this.inetSocketAddress + ')';
        }
    }
}

