/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins;

import io.ktor.client.plugins.HttpTimeoutCapability;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.E;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B%\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\n\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000f\u00a2\u0006\u0004\b\n\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/client/plugins/HttpRequestTimeoutException;", "Ljava/io/IOException;", "Lkotlinx/io/IOException;", "Lkotlinx/coroutines/CopyableThrowable;", "", "url", "", "timeoutMillis", "", "cause", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Throwable;)V", "Lio/ktor/client/request/HttpRequestBuilder;", "request", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "Lio/ktor/client/request/HttpRequestData;", "(Lio/ktor/client/request/HttpRequestData;)V", "createCopy", "()Lio/ktor/client/plugins/HttpRequestTimeoutException;", "Ljava/lang/String;", "Ljava/lang/Long;", "ktor-client-core"})
public final class HttpRequestTimeoutException
extends IOException
implements E<HttpRequestTimeoutException> {
    private final String url;
    private final Long timeoutMillis;

    public HttpRequestTimeoutException(String string, Long l, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringBuilder stringBuilder = new StringBuilder().append("Request timeout has expired [url=").append(string).append(", request_timeout=");
        Object object = l;
        if (object == null) {
            object = "unknown";
        }
        super(stringBuilder.append(object).append(" ms]").toString(), throwable);
        this.url = string;
        this.timeoutMillis = l;
    }

    public /* synthetic */ HttpRequestTimeoutException(String string, Long l, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(string, l, throwable);
    }

    public HttpRequestTimeoutException(HttpRequestBuilder httpRequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"");
        HttpTimeoutConfig httpTimeoutConfig = (HttpTimeoutConfig)httpRequestBuilder.getCapabilityOrNull(HttpTimeoutCapability.INSTANCE);
        this(httpRequestBuilder.getUrl().buildString(), httpTimeoutConfig != null ? httpTimeoutConfig.getRequestTimeoutMillis() : null, null, 4, null);
    }

    public HttpRequestTimeoutException(HttpRequestData httpRequestData) {
        Intrinsics.checkNotNullParameter((Object)httpRequestData, (String)"");
        HttpTimeoutConfig httpTimeoutConfig = (HttpTimeoutConfig)httpRequestData.getCapabilityOrNull(HttpTimeoutCapability.INSTANCE);
        this(httpRequestData.getUrl().toString(), httpTimeoutConfig != null ? httpTimeoutConfig.getRequestTimeoutMillis() : null, null, 4, null);
    }

    public HttpRequestTimeoutException createCopy() {
        return new HttpRequestTimeoutException(this.url, this.timeoutMillis, this.getCause());
    }
}

