/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.RuntimeTypeMapper;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.CallerImpl;
import kotlin.reflect.jvm.internal.calls.InternalUnderlyingValOfInlineClass;
import kotlin.reflect.jvm.internal.calls.ThrowingCaller;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCallerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\"\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"boundReceiver", "", "Lkotlin/reflect/jvm/internal/KPropertyImpl$Accessor;", "getBoundReceiver", "(Lkotlin/reflect/jvm/internal/KPropertyImpl$Accessor;)Ljava/lang/Object;", "computeCallerForAccessor", "Lkotlin/reflect/jvm/internal/calls/Caller;", "isGetter", "", "isJvmFieldPropertyInCompanionObject", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "kotlin-reflection"})
public final class KPropertyImplKt {
    public static final Object getBoundReceiver(KPropertyImpl.Accessor<?, ?> accessor) {
        Intrinsics.checkNotNullParameter(accessor, (String)"");
        return accessor.getProperty().getBoundReceiver();
    }

    private static final Caller<?> computeCallerForAccessor(KPropertyImpl.Accessor<?, ?> accessor, boolean bl) {
        Caller caller;
        if (KDeclarationContainerImpl.Companion.getLOCAL_PROPERTY_SIGNATURE$kotlin_reflection().matches((CharSequence)accessor.getProperty().getSignature())) {
            return ThrowingCaller.INSTANCE;
        }
        JvmPropertySignature jvmPropertySignature = RuntimeTypeMapper.INSTANCE.mapPropertySignature(accessor.getProperty().getDescriptor());
        JvmPropertySignature jvmPropertySignature2 = jvmPropertySignature;
        if (jvmPropertySignature2 instanceof JvmPropertySignature.KotlinProperty) {
            Method method;
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature;
            GenericDeclaration genericDeclaration = ((JvmPropertySignature.KotlinProperty)jvmPropertySignature).getSignature();
            boolean bl2 = false;
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature2 = jvmMethodSignature = bl ? (((JvmProtoBuf.JvmPropertySignature)((Object)genericDeclaration)).hasGetter() ? ((JvmProtoBuf.JvmPropertySignature)((Object)genericDeclaration)).getGetter() : null) : (((JvmProtoBuf.JvmPropertySignature)((Object)genericDeclaration)).hasSetter() ? ((JvmProtoBuf.JvmPropertySignature)((Object)genericDeclaration)).getSetter() : null);
            if (jvmMethodSignature2 != null) {
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature3 = jvmMethodSignature2;
                boolean bl3 = false;
                method = accessor.getProperty().getContainer().findMethodBySignature(((JvmPropertySignature.KotlinProperty)jvmPropertySignature).getNameResolver().getString(jvmMethodSignature3.getName()), ((JvmPropertySignature.KotlinProperty)jvmPropertySignature).getNameResolver().getString(jvmMethodSignature3.getDesc()));
            } else {
                method = null;
            }
            Method method2 = method;
            if (method2 == null) {
                if (InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(accessor.getProperty().getDescriptor()) && Intrinsics.areEqual((Object)accessor.getProperty().getDescriptor().getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
                    GenericDeclaration genericDeclaration2 = ValueClassAwareCallerKt.toInlineClass(accessor.getProperty().getDescriptor().getContainingDeclaration());
                    if (genericDeclaration2 == null || (genericDeclaration2 = ValueClassAwareCallerKt.getInlineClassUnboxMethod(genericDeclaration2, accessor.getProperty().getDescriptor())) == null) {
                        throw new KotlinReflectionInternalError("Underlying property of inline class " + accessor.getProperty() + " should have a field");
                    }
                    genericDeclaration = genericDeclaration2;
                    caller = accessor.isBound() ? (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Bound((Method)genericDeclaration, KPropertyImplKt.getBoundReceiver(accessor)) : (InternalUnderlyingValOfInlineClass)new InternalUnderlyingValOfInlineClass.Unbound((Method)genericDeclaration);
                } else {
                    Field field = accessor.getProperty().getJavaField();
                    if (field == null) {
                        throw new KotlinReflectionInternalError("No accessors or field is found for property " + accessor.getProperty());
                    }
                    genericDeclaration = field;
                    caller = KPropertyImplKt.computeCallerForAccessor$computeFieldCaller(accessor, bl, (Field)((Object)genericDeclaration));
                }
            } else {
                caller = !Modifier.isStatic(method2.getModifiers()) ? (Caller)(accessor.isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundInstance(method2, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Instance(method2)) : (KPropertyImplKt.computeCallerForAccessor$isJvmStaticProperty(accessor) ? (Caller)(accessor.isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundJvmStaticInObject(method2) : (CallerImpl.Method)new CallerImpl.Method.JvmStaticInObject(method2)) : (Caller)(accessor.isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundStatic(method2, false, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Static(method2)));
            }
        } else if (jvmPropertySignature2 instanceof JvmPropertySignature.JavaField) {
            caller = KPropertyImplKt.computeCallerForAccessor$computeFieldCaller(accessor, bl, ((JvmPropertySignature.JavaField)jvmPropertySignature).getField());
        } else if (jvmPropertySignature2 instanceof JvmPropertySignature.JavaMethodProperty) {
            Method method;
            if (bl) {
                method = ((JvmPropertySignature.JavaMethodProperty)jvmPropertySignature).getGetterMethod();
            } else {
                method = ((JvmPropertySignature.JavaMethodProperty)jvmPropertySignature).getSetterMethod();
                if (method == null) {
                    throw new KotlinReflectionInternalError("No source found for setter of Java method property: " + ((JvmPropertySignature.JavaMethodProperty)jvmPropertySignature).getGetterMethod());
                }
            }
            Method method3 = method;
            caller = accessor.isBound() ? (CallerImpl.Method)new CallerImpl.Method.BoundInstance(method3, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.Method)new CallerImpl.Method.Instance(method3);
        } else {
            if (jvmPropertySignature2 instanceof JvmPropertySignature.MappedKotlinProperty) {
                boolean bl4;
                JvmFunctionSignature.KotlinFunction kotlinFunction;
                if (bl) {
                    kotlinFunction = ((JvmPropertySignature.MappedKotlinProperty)jvmPropertySignature).getGetterSignature();
                } else {
                    kotlinFunction = ((JvmPropertySignature.MappedKotlinProperty)jvmPropertySignature).getSetterSignature();
                    if (kotlinFunction == null) {
                        throw new KotlinReflectionInternalError("No setter found for property " + accessor.getProperty());
                    }
                }
                JvmFunctionSignature.KotlinFunction kotlinFunction2 = kotlinFunction;
                Method method = accessor.getProperty().getContainer().findMethodBySignature(kotlinFunction2.getMethodName(), kotlinFunction2.getMethodDesc());
                if (method == null) {
                    throw new KotlinReflectionInternalError("No accessor found for property " + accessor.getProperty());
                }
                Method method4 = method;
                boolean bl5 = bl4 = !Modifier.isStatic(method4.getModifiers());
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "Mapped property cannot have a static accessor: " + accessor.getProperty();
                    throw new AssertionError((Object)string);
                }
                return accessor.isBound() ? (Caller)new CallerImpl.Method.BoundInstance(method4, KPropertyImplKt.getBoundReceiver(accessor)) : (Caller)new CallerImpl.Method.Instance(method4);
            }
            throw new NoWhenBranchMatchedException();
        }
        return ValueClassAwareCallerKt.createValueClassAwareCallerIfNeeded$default(caller, accessor.getDescriptor(), false, 2, null);
    }

    private static final boolean isJvmFieldPropertyInCompanionObject(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (!DescriptorUtils.isCompanionObject(declarationDescriptor2)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2.getContainingDeclaration();
        return DescriptorUtils.isInterface(declarationDescriptor3) || DescriptorUtils.isAnnotationClass(declarationDescriptor3) ? propertyDescriptor instanceof DeserializedPropertyDescriptor && JvmProtoBufUtil.isMovedFromInterfaceCompanion(((DeserializedPropertyDescriptor)propertyDescriptor).getProto()) : true;
    }

    private static final boolean computeCallerForAccessor$isJvmStaticProperty(KPropertyImpl.Accessor<?, ?> accessor) {
        return accessor.getProperty().getDescriptor().getAnnotations().hasAnnotation(UtilKt.getJVM_STATIC());
    }

    private static final boolean computeCallerForAccessor$isNotNullProperty(KPropertyImpl.Accessor<?, ?> accessor) {
        return !TypeUtils.isNullableType(accessor.getProperty().getDescriptor().getType());
    }

    private static final CallerImpl<Field> computeCallerForAccessor$computeFieldCaller(KPropertyImpl.Accessor<?, ?> accessor, boolean bl, Field field) {
        return KPropertyImplKt.isJvmFieldPropertyInCompanionObject(accessor.getProperty().getDescriptor()) || !Modifier.isStatic(field.getModifiers()) ? (bl ? (CallerImpl)(accessor.isBound() ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundInstance(field, KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.Instance(field)) : (accessor.isBound() ? (CallerImpl)new CallerImpl.FieldSetter.BoundInstance(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor), KPropertyImplKt.getBoundReceiver(accessor)) : (CallerImpl)new CallerImpl.FieldSetter.Instance(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor)))) : (KPropertyImplKt.computeCallerForAccessor$isJvmStaticProperty(accessor) ? (bl ? (CallerImpl)(accessor.isBound() ? (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.BoundJvmStaticInObject(field) : (CallerImpl.FieldGetter)new CallerImpl.FieldGetter.JvmStaticInObject(field)) : (accessor.isBound() ? (CallerImpl)new CallerImpl.FieldSetter.BoundJvmStaticInObject(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor)) : (CallerImpl)new CallerImpl.FieldSetter.JvmStaticInObject(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor)))) : (bl ? (CallerImpl)new CallerImpl.FieldGetter.Static(field) : (CallerImpl)new CallerImpl.FieldSetter.Static(field, KPropertyImplKt.computeCallerForAccessor$isNotNullProperty(accessor))));
    }

    public static final /* synthetic */ Caller access$computeCallerForAccessor(KPropertyImpl.Accessor accessor, boolean bl) {
        return KPropertyImplKt.computeCallerForAccessor(accessor, bl);
    }
}

