/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$0;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$$Lambda$1;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u0007*\u00060\bj\u0002`\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "<init>", "()V", "renderer", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "appendReceiverType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "receiver", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "appendReceivers", "callable", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "renderCallable", "", "descriptor", "renderProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "renderFunction", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "renderLambda", "invoke", "renderParameter", "parameter", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "renderType", "type", "Lkotlin/reflect/jvm/internal/impl/types/KotlinType;", "kotlin-reflection"})
public final class ReflectionObjectRenderer {
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();
    private static final DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;

    private ReflectionObjectRenderer() {
    }

    private final void appendReceiverType(StringBuilder stringBuilder, ReceiverParameterDescriptor receiverParameterDescriptor) {
        if (receiverParameterDescriptor != null) {
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            stringBuilder.append(this.renderType(kotlinType));
            stringBuilder.append(".");
        }
    }

    private final void appendReceivers(StringBuilder stringBuilder, CallableDescriptor callableDescriptor) {
        boolean bl;
        ReceiverParameterDescriptor receiverParameterDescriptor = UtilKt.getInstanceReceiverParameter(callableDescriptor);
        ReceiverParameterDescriptor receiverParameterDescriptor2 = callableDescriptor.getExtensionReceiverParameter();
        this.appendReceiverType(stringBuilder, receiverParameterDescriptor);
        boolean bl2 = bl = receiverParameterDescriptor != null && receiverParameterDescriptor2 != null;
        if (bl) {
            stringBuilder.append("(");
        }
        this.appendReceiverType(stringBuilder, receiverParameterDescriptor2);
        if (bl) {
            stringBuilder.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor callableDescriptor) {
        String string;
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        if (callableDescriptor2 instanceof PropertyDescriptor) {
            string = this.renderProperty((PropertyDescriptor)callableDescriptor);
        } else if (callableDescriptor2 instanceof FunctionDescriptor) {
            string = this.renderFunction((FunctionDescriptor)callableDescriptor);
        } else {
            throw new IllegalStateException(("Illegal callable: " + callableDescriptor).toString());
        }
        return string;
    }

    public final String renderProperty(PropertyDescriptor propertyDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append(propertyDescriptor.isVar() ? "var " : "val ");
        INSTANCE.appendReceivers(stringBuilder2, propertyDescriptor);
        Name name = propertyDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder2.append(renderer.renderName(name, true));
        stringBuilder2.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        return stringBuilder.toString();
    }

    public final String renderFunction(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("fun ");
        INSTANCE.appendReceivers(stringBuilder2, functionDescriptor);
        Name name = functionDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder2.append(renderer.renderName(name, true));
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)ReflectionObjectRenderer$$Lambda$0.INSTANCE, (int)48, null);
        stringBuilder2.append(": ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        return stringBuilder.toString();
    }

    public final String renderLambda(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendReceivers(stringBuilder2, functionDescriptor);
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)ReflectionObjectRenderer$$Lambda$1.INSTANCE, (int)48, null);
        stringBuilder2.append(" -> ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        stringBuilder2.append(INSTANCE.renderType(kotlinType));
        return stringBuilder.toString();
    }

    public final String renderParameter(KParameterImpl kParameterImpl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)kParameterImpl, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[kParameterImpl.getKind().ordinal()]) {
            case 1: {
                StringBuilder stringBuilder3 = stringBuilder2.append("extension receiver parameter");
                break;
            }
            case 2: {
                StringBuilder stringBuilder3 = stringBuilder2.append("instance parameter");
                break;
            }
            case 3: {
                StringBuilder stringBuilder3 = stringBuilder2.append("parameter #" + kParameterImpl.getIndex() + ' ' + kParameterImpl.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        stringBuilder2.append(" of ");
        stringBuilder2.append(INSTANCE.renderCallable(kParameterImpl.getCallable().getDescriptor()));
        return stringBuilder.toString();
    }

    public final String renderType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return renderer.renderType(kotlinType);
    }

    private static final CharSequence renderFunction$lambda$2$lambda$1(ValueParameterDescriptor valueParameterDescriptor) {
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        return INSTANCE.renderType(kotlinType);
    }

    private static final CharSequence renderLambda$lambda$4$lambda$3(ValueParameterDescriptor valueParameterDescriptor) {
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        return INSTANCE.renderType(kotlinType);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda0(ValueParameterDescriptor valueParameterDescriptor) {
        return ReflectionObjectRenderer.renderFunction$lambda$2$lambda$1(valueParameterDescriptor);
    }

    static /* synthetic */ CharSequence accessor$ReflectionObjectRenderer$lambda1(ValueParameterDescriptor valueParameterDescriptor) {
        return ReflectionObjectRenderer.renderLambda$lambda$4$lambda$3(valueParameterDescriptor);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KParameter.Kind.values().length];
            try {
                nArray[KParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.INSTANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

