/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.MutableClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class SuspendFunctionTypesKt {
    private static final MutableClassDescriptor FAKE_CONTINUATION_CLASS_DESCRIPTOR;

    public static final SimpleType transformSuspendFunctionToRuntimeFunctionType(KotlinType kotlinType) {
        Collection<KotlinType> collection;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        boolean bl = FunctionTypesKt.isSuspendFunctionType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "This type should be suspend function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType);
        KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType);
        Annotations annotations = kotlinType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(kotlinType);
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl4 = false;
        for (Object t : iterable2) {
            TypeProjection typeProjection = (TypeProjection)t;
            collection = collection2;
            boolean bl5 = false;
            collection.add(typeProjection.getType());
        }
        collection = (List)collection2;
        Collection collection3 = collection;
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        TypeConstructor typeConstructor2 = FAKE_CONTINUATION_CLASS_DESCRIPTOR.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        List list2 = CollectionsKt.plus((Collection)collection3, (Object)KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor2, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType))), false, null, 16, null));
        SimpleType simpleType = TypeUtilsKt.getBuiltIns(kotlinType).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        return FunctionTypesKt.createFunctionType$default(kotlinBuiltIns, annotations, kotlinType2, list, list2, null, simpleType, false, 128, null).makeNullableAsSpecified(kotlinType.isMarkedNullable());
    }

    static {
        MutableClassDescriptor mutableClassDescriptor;
        MutableClassDescriptor mutableClassDescriptor2 = mutableClassDescriptor = new MutableClassDescriptor(new EmptyPackageFragmentDescriptor(ErrorUtils.INSTANCE.getErrorModule(), StandardNames.COROUTINES_PACKAGE_FQ_NAME), ClassKind.INTERFACE, false, false, StandardNames.CONTINUATION_INTERFACE_FQ_NAME.shortName(), SourceElement.NO_SOURCE, LockBasedStorageManager.NO_LOCKS);
        boolean bl = false;
        mutableClassDescriptor2.setModality(Modality.ABSTRACT);
        mutableClassDescriptor2.setVisibility(DescriptorVisibilities.PUBLIC);
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound(mutableClassDescriptor2, Annotations.Companion.getEMPTY(), false, Variance.IN_VARIANCE, Name.identifier("T"), 0, LockBasedStorageManager.NO_LOCKS);
        MutableClassDescriptor mutableClassDescriptor3 = mutableClassDescriptor2;
        boolean bl2 = false;
        mutableClassDescriptor3.setTypeParameterDescriptors(CollectionsKt.listOf((Object)typeParameterDescriptor));
        mutableClassDescriptor2.createTypeConstructor();
        FAKE_CONTINUATION_CLASS_DESCRIPTOR = mutableClassDescriptor;
    }
}

