/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.SimpleFunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;

public final class FunctionInvokeDescriptor
extends SimpleFunctionDescriptorImpl {
    public static final Factory Factory = new Factory(null);

    private FunctionInvokeDescriptor(DeclarationDescriptor declarationDescriptor, FunctionInvokeDescriptor functionInvokeDescriptor, CallableMemberDescriptor.Kind kind, boolean bl) {
        super(declarationDescriptor, functionInvokeDescriptor, Annotations.Companion.getEMPTY(), OperatorNameConventions.INVOKE, kind, SourceElement.NO_SOURCE);
        this.setOperator(true);
        this.setSuspend(bl);
        this.setHasStableParameterNames(false);
    }

    @Override
    protected FunctionDescriptor doSubstitute(FunctionDescriptorImpl.CopyConfiguration copyConfiguration) {
        boolean bl;
        Object object;
        Object object22;
        boolean bl2;
        Iterable iterable;
        FunctionInvokeDescriptor functionInvokeDescriptor;
        block6: {
            Intrinsics.checkNotNullParameter((Object)copyConfiguration, (String)"");
            FunctionInvokeDescriptor functionInvokeDescriptor2 = (FunctionInvokeDescriptor)super.doSubstitute(copyConfiguration);
            if (functionInvokeDescriptor2 == null) {
                return null;
            }
            functionInvokeDescriptor = functionInvokeDescriptor2;
            List<ValueParameterDescriptor> list = functionInvokeDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl3 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl2 = true;
            } else {
                for (Object object22 : iterable) {
                    object = (ValueParameterDescriptor)object22;
                    bl = false;
                    KotlinType kotlinType = object.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                    if (!(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType) != null)) continue;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return functionInvokeDescriptor;
        }
        List<ValueParameterDescriptor> list = functionInvokeDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable2 = list;
        boolean bl4 = false;
        object22 = iterable2;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        bl = false;
        Iterator iterator2 = object22.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)t;
            Object object3 = object;
            boolean bl5 = false;
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            object3.add(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType));
        }
        iterable = (List)object;
        return functionInvokeDescriptor.replaceParameterNames((List<Name>)iterable);
    }

    @Override
    protected FunctionDescriptorImpl createSubstitutedCopy(DeclarationDescriptor declarationDescriptor, FunctionDescriptor functionDescriptor, CallableMemberDescriptor.Kind kind, Name name, Annotations annotations, SourceElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        return new FunctionInvokeDescriptor(declarationDescriptor, (FunctionInvokeDescriptor)functionDescriptor, kind, this.isSuspend());
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isTailrec() {
        return false;
    }

    private final FunctionDescriptor replaceParameterNames(List<Name> list) {
        boolean bl;
        List list2;
        Object object;
        Object object2;
        block12: {
            Object object32;
            boolean bl2;
            Collection collection;
            Iterable iterable4;
            boolean bl3;
            int n = this.getValueParameters().size() - list.size();
            boolean bl4 = bl3 = n == 0 || n == 1;
            if (_Assertions.ENABLED && !bl3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (n == 0) {
                boolean bl5;
                block11: {
                    Iterable iterable2 = list;
                    List<ValueParameterDescriptor> list3 = this.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"");
                    Iterable iterable3 = CollectionsKt.zip((Iterable)iterable2, (Iterable)list3);
                    boolean bl6 = false;
                    if (iterable3 instanceof Collection && ((Collection)iterable3).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Iterable iterable4 : iterable3) {
                            collection = (Pair)iterable4;
                            bl2 = false;
                            Object object4 = (Name)collection.component1();
                            if (Intrinsics.areEqual((Object)object4, (Object)(object32 = (ValueParameterDescriptor)collection.component2()).getName())) continue;
                            bl5 = false;
                            break block11;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    return this;
                }
            }
            List<ValueParameterDescriptor> list4 = this.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"");
            object2 = list4;
            boolean bl7 = false;
            iterable4 = object2;
            collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            bl2 = false;
            for (Object object32 : iterable4) {
                Name name;
                Name name2;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object32;
                object = collection;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor.getName(), (String)"");
                int n2 = valueParameterDescriptor.getIndex();
                int n3 = n2 - n;
                if (n3 >= 0 && (name2 = list.get(n3)) != null) {
                    name = name2;
                }
                object.add(valueParameterDescriptor.copy(this, name, n2));
            }
            list2 = (List)collection;
            iterable4 = list;
            object = this.newCopyBuilder(TypeSubstitutor.EMPTY);
            boolean bl9 = false;
            if (iterable4 instanceof Collection && ((Collection)iterable4).isEmpty()) {
                bl = false;
            } else {
                for (Object object4 : iterable4) {
                    object32 = (Name)object4;
                    boolean bl10 = false;
                    if (!(object32 == null)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        boolean bl11 = bl;
        FunctionDescriptorImpl.CopyConfiguration copyConfiguration = ((FunctionDescriptorImpl.CopyConfiguration)((FunctionDescriptorImpl.CopyConfiguration)object).setHasSynthesizedParameterNames(bl11).setValueParameters(list2)).setOriginal(this.getOriginal());
        Intrinsics.checkNotNullExpressionValue((Object)copyConfiguration, (String)"");
        object2 = copyConfiguration;
        FunctionDescriptor functionDescriptor = super.doSubstitute((FunctionDescriptorImpl.CopyConfiguration)object2);
        Intrinsics.checkNotNull((Object)functionDescriptor);
        return functionDescriptor;
    }

    public /* synthetic */ FunctionInvokeDescriptor(DeclarationDescriptor declarationDescriptor, FunctionInvokeDescriptor functionInvokeDescriptor, CallableMemberDescriptor.Kind kind, boolean bl, DefaultConstructorMarker defaultConstructorMarker) {
        this(declarationDescriptor, functionInvokeDescriptor, kind, bl);
    }

    public static final class Factory {
        private Factory() {
        }

        public final FunctionInvokeDescriptor create(FunctionClassDescriptor functionClassDescriptor, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)functionClassDescriptor, (String)"");
            List<TypeParameterDescriptor> list = functionClassDescriptor.getDeclaredTypeParameters();
            FunctionInvokeDescriptor functionInvokeDescriptor = new FunctionInvokeDescriptor(functionClassDescriptor, null, CallableMemberDescriptor.Kind.DECLARATION, bl, null);
            Iterable iterable = list;
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            ReceiverParameterDescriptor receiverParameterDescriptor = functionClassDescriptor.getThisAsReceiverParameter();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = null;
            FunctionInvokeDescriptor functionInvokeDescriptor2 = functionInvokeDescriptor;
            boolean bl2 = false;
            Iterable iterable2 = new ArrayList();
            for (Object t : iterable) {
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t;
                boolean bl3 = false;
                if (!(typeParameterDescriptor.getVariance() == Variance.IN_VARIANCE)) break;
                ((ArrayList)iterable2).add(t);
            }
            Object object = (List)iterable2;
            iterable = CollectionsKt.withIndex((Iterable)((Iterable)object));
            bl2 = false;
            iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl4 = false;
            for (Object e : iterable2) {
                IndexedValue indexedValue = (IndexedValue)e;
                object = collection;
                boolean bl5 = false;
                object.add(Factory.createValueParameter(functionInvokeDescriptor, indexedValue.getIndex(), (TypeParameterDescriptor)indexedValue.getValue()));
            }
            object = (List)collection;
            functionInvokeDescriptor2.initialize(receiverParameterDescriptor2, receiverParameterDescriptor, list3, list2, (List)object, (KotlinType)((TypeParameterDescriptor)CollectionsKt.last(list)).getDefaultType(), Modality.ABSTRACT, DescriptorVisibilities.PUBLIC);
            functionInvokeDescriptor.setHasSynthesizedParameterNames(true);
            return functionInvokeDescriptor;
        }

        private final ValueParameterDescriptor createValueParameter(FunctionInvokeDescriptor functionInvokeDescriptor, int n, TypeParameterDescriptor typeParameterDescriptor) {
            String string;
            String string2 = typeParameterDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2;
            if (Intrinsics.areEqual((Object)string3, (Object)"T")) {
                string = "instance";
            } else if (Intrinsics.areEqual((Object)string3, (Object)"E")) {
                string = "receiver";
            } else {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            }
            String string5 = string;
            CallableDescriptor callableDescriptor = functionInvokeDescriptor;
            Annotations annotations = Annotations.Companion.getEMPTY();
            Name name = Name.identifier(string5);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            SimpleType simpleType = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            KotlinType kotlinType = simpleType;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
            return new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations, name, kotlinType, false, false, false, null, sourceElement);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

