/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

public final class JvmBuiltInsSignatures {
    public static final JvmBuiltInsSignatures INSTANCE = new JvmBuiltInsSignatures();
    private static final Set<String> DROP_LIST_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_METHOD_SIGNATURES;
    private static final Set<String> DEPRECATED_LIST_METHODS;
    private static final Set<String> VISIBLE_METHOD_SIGNATURES;
    private static final Set<String> MUTABLE_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_CONSTRUCTOR_SIGNATURES;
    private static final Set<String> VISIBLE_CONSTRUCTOR_SIGNATURES;

    private JvmBuiltInsSignatures() {
    }

    public final Set<String> getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    private final Set<String> buildPrimitiveValueMethodsSet() {
        boolean bl = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl2 = false;
        Object object = new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.CHAR};
        object = CollectionsKt.listOf((Object[])object);
        Collection collection = new LinkedHashSet();
        boolean bl3 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            Object object2 = (JvmPrimitiveType)((Object)t);
            boolean bl4 = false;
            String string = object2.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String[] stringArray = new String[]{object2.getJavaKeywordName() + "Value()" + object2.getDesc()};
            object2 = signatureBuildingComponents.inJavaLang(string, stringArray);
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (LinkedHashSet)collection;
    }

    public final Set<String> getDEPRECATED_LIST_METHODS() {
        return DEPRECATED_LIST_METHODS;
    }

    public final Set<String> getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    public final Set<String> getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    public final Set<String> getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    private final Set<String> buildPrimitiveStringConstructorsSet() {
        boolean bl = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl2 = false;
        Object object = new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.BYTE, JvmPrimitiveType.DOUBLE, JvmPrimitiveType.FLOAT, JvmPrimitiveType.BYTE, JvmPrimitiveType.INT, JvmPrimitiveType.LONG, JvmPrimitiveType.SHORT};
        object = CollectionsKt.listOf((Object[])object);
        Collection collection = new LinkedHashSet();
        boolean bl3 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            Object object2 = (JvmPrimitiveType)((Object)t);
            boolean bl4 = false;
            String string = object2.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String[] stringArray = new String[]{"Ljava/lang/String;"};
            String[] stringArray2 = signatureBuildingComponents.constructors(stringArray);
            object2 = signatureBuildingComponents.inJavaLang(string, Arrays.copyOf(stringArray2, stringArray2.length));
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (LinkedHashSet)collection;
    }

    public final boolean isSerializableInJava(FqNameUnsafe fqNameUnsafe) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        if (this.isArrayOrPrimitiveArray(fqNameUnsafe)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        try {
            clazz = Class.forName(classId2.asSingleFqName().asString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        Class<?> clazz2 = clazz;
        return Serializable.class.isAssignableFrom(clazz2);
    }

    public final boolean isArrayOrPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.array) || StandardNames.isPrimitiveArray(fqNameUnsafe);
    }

    static {
        String[] stringArray = new String[]{"toArray()[Ljava/lang/Object;", "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"};
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(SignatureBuildingComponents.INSTANCE.inJavaUtil("Collection", stringArray), (Object)"java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        boolean bl = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl2 = false;
        String[] stringArray2 = new String[]{"sort(Ljava/util/Comparator;)V", "reversed()Ljava/util/List;"};
        Set set = SetsKt.plus(INSTANCE.buildPrimitiveValueMethodsSet(), (Iterable)signatureBuildingComponents.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"codePointAt(I)I", "codePointBefore(I)I", "codePointCount(II)I", "compareToIgnoreCase(Ljava/lang/String;)I", "concat(Ljava/lang/String;)Ljava/lang/String;", "contains(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/StringBuffer;)Z", "endsWith(Ljava/lang/String;)Z", "equalsIgnoreCase(Ljava/lang/String;)Z", "getBytes()[B", "getBytes(II[BI)V", "getBytes(Ljava/lang/String;)[B", "getBytes(Ljava/nio/charset/Charset;)[B", "getChars(II[CI)V", "indexOf(I)I", "indexOf(II)I", "indexOf(Ljava/lang/String;)I", "indexOf(Ljava/lang/String;I)I", "intern()Ljava/lang/String;", "isEmpty()Z", "lastIndexOf(I)I", "lastIndexOf(II)I", "lastIndexOf(Ljava/lang/String;)I", "lastIndexOf(Ljava/lang/String;I)I", "matches(Ljava/lang/String;)Z", "offsetByCodePoints(II)I", "regionMatches(ILjava/lang/String;II)Z", "regionMatches(ZILjava/lang/String;II)Z", "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(CC)Ljava/lang/String;", "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", "split(Ljava/lang/String;I)[Ljava/lang/String;", "split(Ljava/lang/String;)[Ljava/lang/String;", "startsWith(Ljava/lang/String;I)Z", "startsWith(Ljava/lang/String;)Z", "substring(II)Ljava/lang/String;", "substring(I)Ljava/lang/String;", "toCharArray()[C", "toLowerCase()Ljava/lang/String;", "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;", "toUpperCase()Ljava/lang/String;", "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;", "trim()Ljava/lang/String;", "isBlank()Z", "lines()Ljava/util/stream/Stream;", "repeat(I)Ljava/lang/String;"};
        Set set2 = SetsKt.plus((Set)set, (Iterable)signatureBuildingComponents.inJavaLang("String", stringArray2));
        stringArray2 = new String[]{"isInfinite()Z", "isNaN()Z"};
        Set set3 = SetsKt.plus((Set)set2, (Iterable)signatureBuildingComponents.inJavaLang("Double", stringArray2));
        stringArray2 = new String[]{"isInfinite()Z", "isNaN()Z"};
        Set set4 = SetsKt.plus((Set)set3, (Iterable)signatureBuildingComponents.inJavaLang("Float", stringArray2));
        stringArray2 = new String[]{"getDeclaringClass()Ljava/lang/Class;", "finalize()V"};
        Set set5 = SetsKt.plus((Set)set4, (Iterable)signatureBuildingComponents.inJavaLang("Enum", stringArray2));
        stringArray2 = new String[]{"isEmpty()Z"};
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus((Set)set5, (Iterable)signatureBuildingComponents.inJavaLang("CharSequence", stringArray2));
        bl = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl2 = false;
        stringArray2 = new String[]{"getFirst()Ljava/lang/Object;", "getLast()Ljava/lang/Object;"};
        DEPRECATED_LIST_METHODS = signatureBuildingComponents.inJavaUtil("List", stringArray2);
        bl = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl2 = false;
        stringArray2 = new String[]{"codePoints()Ljava/util/stream/IntStream;", "chars()Ljava/util/stream/IntStream;"};
        Set<String> set6 = signatureBuildingComponents.inJavaLang("CharSequence", stringArray2);
        stringArray2 = new String[]{"forEachRemaining(Ljava/util/function/Consumer;)V"};
        Set set7 = SetsKt.plus(set6, (Iterable)signatureBuildingComponents.inJavaUtil("Iterator", stringArray2));
        stringArray2 = new String[]{"forEach(Ljava/util/function/Consumer;)V", "spliterator()Ljava/util/Spliterator;"};
        Set set8 = SetsKt.plus((Set)set7, (Iterable)signatureBuildingComponents.inJavaLang("Iterable", stringArray2));
        stringArray2 = new String[]{"setStackTrace([Ljava/lang/StackTraceElement;)V", "fillInStackTrace()Ljava/lang/Throwable;", "getLocalizedMessage()Ljava/lang/String;", "printStackTrace()V", "printStackTrace(Ljava/io/PrintStream;)V", "printStackTrace(Ljava/io/PrintWriter;)V", "getStackTrace()[Ljava/lang/StackTraceElement;", "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "getSuppressed()[Ljava/lang/Throwable;", "addSuppressed(Ljava/lang/Throwable;)V"};
        Set set9 = SetsKt.plus((Set)set8, (Iterable)signatureBuildingComponents.inJavaLang("Throwable", stringArray2));
        stringArray2 = new String[]{"spliterator()Ljava/util/Spliterator;", "parallelStream()Ljava/util/stream/Stream;", "stream()Ljava/util/stream/Stream;", "removeIf(Ljava/util/function/Predicate;)Z"};
        Set set10 = SetsKt.plus((Set)set9, (Iterable)signatureBuildingComponents.inJavaUtil("Collection", stringArray2));
        stringArray2 = new String[]{"replaceAll(Ljava/util/function/UnaryOperator;)V", "addFirst(Ljava/lang/Object;)V", "addLast(Ljava/lang/Object;)V", "removeFirst()Ljava/lang/Object;", "removeLast()Ljava/lang/Object;"};
        Set set11 = SetsKt.plus((Set)set10, (Iterable)signatureBuildingComponents.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "forEach(Ljava/util/function/BiConsumer;)V", "replaceAll(Ljava/util/function/BiFunction;)V", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"};
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus((Set)set11, (Iterable)signatureBuildingComponents.inJavaUtil("Map", stringArray2));
        bl = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl2 = false;
        stringArray2 = new String[]{"removeIf(Ljava/util/function/Predicate;)Z"};
        Set<String> set12 = signatureBuildingComponents.inJavaUtil("Collection", stringArray2);
        stringArray2 = new String[]{"replaceAll(Ljava/util/function/UnaryOperator;)V", "sort(Ljava/util/Comparator;)V", "addFirst(Ljava/lang/Object;)V", "addLast(Ljava/lang/Object;)V", "removeFirst()Ljava/lang/Object;", "removeLast()Ljava/lang/Object;"};
        Set set13 = SetsKt.plus(set12, (Iterable)signatureBuildingComponents.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove(Ljava/lang/Object;Ljava/lang/Object;)Z", "replaceAll(Ljava/util/function/BiFunction;)V", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"};
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus((Set)set13, (Iterable)signatureBuildingComponents.inJavaUtil("Map", stringArray2));
        bl = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl2 = false;
        stringArray2 = new String[]{"D"};
        String[] stringArray3 = signatureBuildingComponents.constructors(stringArray2);
        Set set14 = SetsKt.plus(INSTANCE.buildPrimitiveStringConstructorsSet(), (Iterable)signatureBuildingComponents.inJavaLang("Float", Arrays.copyOf(stringArray3, stringArray3.length)));
        stringArray2 = new String[]{"[C", "[CII", "[III", "[BIILjava/lang/String;", "[BIILjava/nio/charset/Charset;", "[BLjava/lang/String;", "[BLjava/nio/charset/Charset;", "[BII", "[B", "Ljava/lang/StringBuffer;", "Ljava/lang/StringBuilder;"};
        stringArray3 = signatureBuildingComponents.constructors(stringArray2);
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus((Set)set14, (Iterable)signatureBuildingComponents.inJavaLang("String", Arrays.copyOf(stringArray3, stringArray3.length)));
        bl = false;
        signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        bl2 = false;
        stringArray2 = new String[]{"Ljava/lang/String;Ljava/lang/Throwable;ZZ"};
        stringArray3 = signatureBuildingComponents.constructors(stringArray2);
        VISIBLE_CONSTRUCTOR_SIGNATURES = signatureBuildingComponents.inJavaLang("Throwable", Arrays.copyOf(stringArray3, stringArray3.length));
    }
}

