/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class PackagePartScopeCache {
    private final DeserializedDescriptorResolver resolver;
    private final ReflectKotlinClassFinder kotlinClassFinder;
    private final ConcurrentHashMap<ClassId, MemberScope> cache;

    public PackagePartScopeCache(DeserializedDescriptorResolver deserializedDescriptorResolver, ReflectKotlinClassFinder reflectKotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)deserializedDescriptorResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)reflectKotlinClassFinder, (String)"");
        this.resolver = deserializedDescriptorResolver;
        this.kotlinClassFinder = reflectKotlinClassFinder;
        this.cache = new ConcurrentHashMap();
    }

    public final MemberScope getPackagePartScope(ReflectKotlinClass reflectKotlinClass) {
        Intrinsics.checkNotNullParameter((Object)reflectKotlinClass, (String)"");
        ConcurrentMap concurrentMap = this.cache;
        ClassId classId = reflectKotlinClass.getClassId();
        boolean bl = false;
        Object object = concurrentMap.get(classId);
        if (object == null) {
            List list;
            Object object2;
            boolean bl2;
            String string;
            Object object3;
            boolean bl3;
            Iterable iterable;
            Iterable iterable2;
            Object object4;
            boolean bl4 = false;
            FqName fqName = reflectKotlinClass.getClassId().getPackageFqName();
            if (reflectKotlinClass.getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
                object4 = reflectKotlinClass.getClassHeader().getMultifilePartNames();
                boolean bl5 = false;
                iterable2 = object4;
                Collection collection = new ArrayList();
                boolean bl6 = false;
                iterable = iterable2;
                bl3 = false;
                for (Object t : iterable) {
                    KotlinJvmBinaryClass kotlinJvmBinaryClass;
                    object3 = t;
                    boolean bl7 = false;
                    string = (String)object3;
                    bl2 = false;
                    FqName fqName2 = JvmClassName.byInternalName(string).getFqNameForTopLevelClassMaybeWithDollars();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
                    object2 = ClassId.Companion.topLevel(fqName2);
                    if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.kotlinClassFinder, (ClassId)object2, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.resolver.getComponents().getConfiguration())) == null) continue;
                    boolean bl8 = false;
                    collection.add(kotlinJvmBinaryClass);
                }
                list = (List)collection;
            } else {
                list = CollectionsKt.listOf((Object)reflectKotlinClass);
            }
            List list2 = list;
            object4 = new EmptyPackageFragmentDescriptor(this.resolver.getComponents().getModuleDescriptor(), fqName);
            iterable2 = list2;
            boolean bl9 = false;
            Iterable iterable3 = iterable2;
            iterable = new ArrayList();
            bl3 = false;
            Iterable iterable4 = iterable3;
            boolean bl10 = false;
            object3 = iterable4.iterator();
            while (object3.hasNext()) {
                MemberScope memberScope;
                Object e = object3.next();
                string = e;
                bl2 = false;
                object2 = (KotlinJvmBinaryClass)((Object)string);
                boolean bl11 = false;
                if (this.resolver.createKotlinPackagePartScope((PackageFragmentDescriptor)object4, (KotlinJvmBinaryClass)object2) == null) continue;
                boolean bl12 = false;
                iterable.add(memberScope);
            }
            List list3 = CollectionsKt.toList((Iterable)((List)iterable));
            MemberScope memberScope = ChainedMemberScope.Companion.create("package " + fqName + " (" + reflectKotlinClass + ')', list3);
            boolean bl13 = false;
            object = concurrentMap.putIfAbsent(classId, memberScope);
            if (object == null) {
                object = memberScope;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"");
        return (MemberScope)object;
    }
}

