/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaPackage;
import kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        this.classLoader = classLoader;
    }

    @Override
    public JavaClass findClass(JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"");
        ClassId classId = request.getClassId();
        FqName fqName = classId.getPackageFqName();
        String string = StringsKt.replace$default((String)classId.getRelativeClassName().asString(), (char)'.', (char)'$', (boolean)false, (int)4, null);
        String string2 = fqName.isRoot() ? string : fqName.asString() + '.' + string;
        Class<?> clazz = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, string2);
        return clazz != null ? (JavaClass)new ReflectJavaClass(clazz) : null;
    }

    @Override
    public JavaPackage findPackage(FqName fqName, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return new ReflectJavaPackage(fqName);
    }

    @Override
    public Set<String> knownClassNamesInPackage(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return null;
    }
}

