/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;

final class Java16RecordComponentsLoader {
    public static final Java16RecordComponentsLoader INSTANCE = new Java16RecordComponentsLoader();
    private static Cache _cache;

    private Java16RecordComponentsLoader() {
    }

    private final Cache buildCache(Object object) {
        Cache cache;
        Class<?> clazz = object.getClass();
        try {
            cache = new Cache(clazz.getMethod("getType", new Class[0]), clazz.getMethod("getAccessor", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            cache = new Cache(null, null);
        }
        return cache;
    }

    private final Cache initCache(Object object) {
        Cache cache = _cache;
        if (cache == null) {
            _cache = cache = this.buildCache(object);
        }
        return cache;
    }

    public final Class<?> loadGetType(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Cache cache = this.initCache(object);
        Method method = cache.getGetType();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Object object2 = method2.invoke(object, new Object[0]);
        Intrinsics.checkNotNull((Object)object2);
        return (Class)object2;
    }

    public final Method loadGetAccessor(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Cache cache = this.initCache(object);
        Method method = cache.getGetAccessor();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Object object2 = method2.invoke(object, new Object[0]);
        Intrinsics.checkNotNull((Object)object2);
        return (Method)object2;
    }

    public static final class Cache {
        private final Method getType;
        private final Method getAccessor;

        public Cache(Method method, Method method2) {
            this.getType = method;
            this.getAccessor = method2;
        }

        public final Method getGetType() {
            return this.getType;
        }

        public final Method getGetAccessor() {
            return this.getAccessor;
        }
    }
}

