/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;

final class Java16SealedRecordLoader {
    public static final Java16SealedRecordLoader INSTANCE = new Java16SealedRecordLoader();
    private static Cache _cache;

    private Java16SealedRecordLoader() {
    }

    private final Cache buildCache() {
        Cache cache;
        Class<Class> clazz = Class.class;
        try {
            cache = new Cache(clazz.getMethod("isSealed", new Class[0]), clazz.getMethod("getPermittedSubclasses", new Class[0]), clazz.getMethod("isRecord", new Class[0]), clazz.getMethod("getRecordComponents", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            cache = new Cache(null, null, null, null);
        }
        return cache;
    }

    private final Cache initCache() {
        Cache cache = _cache;
        if (cache == null) {
            _cache = cache = this.buildCache();
        }
        return cache;
    }

    public final Boolean loadIsSealed(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Cache cache = this.initCache();
        Method method = cache.isSealed();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Object object = method2.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    public final Class<?>[] loadGetPermittedSubclasses(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Cache cache = this.initCache();
        Method method = cache.getGetPermittedSubclasses();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Object object = method2.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object);
        return (Class[])object;
    }

    public final Boolean loadIsRecord(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Cache cache = this.initCache();
        Method method = cache.isRecord();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Object object = method2.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    public final Object[] loadGetRecordComponents(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Cache cache = this.initCache();
        Method method = cache.getGetRecordComponents();
        if (method == null) {
            return null;
        }
        Method method2 = method;
        return (Object[])method2.invoke(clazz, new Object[0]);
    }

    public static final class Cache {
        private final Method isSealed;
        private final Method getPermittedSubclasses;
        private final Method isRecord;
        private final Method getRecordComponents;

        public Cache(Method method, Method method2, Method method3, Method method4) {
            this.isSealed = method;
            this.getPermittedSubclasses = method2;
            this.isRecord = method3;
            this.getRecordComponents = method4;
        }

        public final Method isSealed() {
            return this.isSealed;
        }

        public final Method getGetPermittedSubclasses() {
            return this.getPermittedSubclasses;
        }

        public final Method isRecord() {
            return this.isRecord;
        }

        public final Method getGetRecordComponents() {
            return this.getRecordComponents;
        }
    }
}

