/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    public abstract Member getMember();

    @Override
    public AnnotatedElement getElement() {
        Member member = this.getMember();
        Intrinsics.checkNotNull((Object)member);
        return (AnnotatedElement)((Object)member);
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    public Name getName() {
        Object object;
        block3: {
            block2: {
                object = this.getMember().getName();
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                Name name = Name.identifier(string);
                object = name;
                if (name != null) break block3;
            }
            object = SpecialNames.NO_NAME_PROVIDED;
        }
        return object;
    }

    @Override
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return new ReflectJavaClass(clazz);
    }

    protected final List<JavaValueParameter> getValueParameters(Type[] typeArray, Annotation[][] annotationArray, boolean bl) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)typeArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationArray, (String)"");
        ArrayList<ReflectJavaValueParameter> arrayList = new ArrayList<ReflectJavaValueParameter>(typeArray.length);
        List<String> list2 = list = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        int n = list2 != null ? list2.size() - typeArray.length : 0;
        int n2 = typeArray.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            ReflectJavaType reflectJavaType = ReflectJavaType.Factory.create(typeArray[i]);
            if (list != null) {
                List<String> list3;
                boolean bl2 = false;
                string = (String)CollectionsKt.getOrNull(list3, (int)(i + n));
                if (string == null) {
                    throw new IllegalStateException(("No parameter with index " + i + '+' + n + " (name=" + this.getName() + " type=" + reflectJavaType + ") in " + this).toString());
                }
            } else {
                string = null;
            }
            String string2 = string;
            boolean bl3 = bl && i == ArraysKt.getLastIndex((Object[])typeArray);
            arrayList.add(new ReflectJavaValueParameter(reflectJavaType, annotationArray[i], string2, bl3));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        return object instanceof ReflectJavaMember && Intrinsics.areEqual((Object)this.getMember(), (Object)((ReflectJavaMember)object).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    public List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Annotation[] annotationArray = this.getElement();
        return annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null ? ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, fqName) : null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public Visibility getVisibility() {
        int n = this.getModifiers();
        boolean bl = false;
        return Modifier.isPublic(n) ? (Visibility)Visibilities.Public.INSTANCE : (Modifier.isPrivate(n) ? (Visibility)Visibilities.Private.INSTANCE : (Modifier.isProtected(n) ? (Modifier.isStatic(n) ? (Visibility)JavaVisibilities.ProtectedStaticVisibility.INSTANCE : (Visibility)JavaVisibilities.ProtectedAndPackage.INSTANCE) : (Visibility)JavaVisibilities.PackageVisibility.INSTANCE));
    }
}

