/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class UtilKt {
    public static final List<ValueParameterDescriptor> copyValueParameters(Collection<? extends KotlinType> collection, Collection<? extends ValueParameterDescriptor> collection2, CallableDescriptor callableDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter(collection2, (String)"");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        boolean bl2 = bl = collection.size() == collection2.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Different value parameters sizes: Enhanced = " + collection.size() + ", Old = " + collection2.size();
            throw new AssertionError((Object)string);
        }
        Iterable iterable = CollectionsKt.zip((Iterable)collection, (Iterable)collection2);
        boolean bl4 = false;
        Iterable iterable2 = iterable;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl5 = false;
        for (Object t : iterable2) {
            Pair pair = (Pair)t;
            Collection collection4 = collection3;
            boolean bl6 = false;
            KotlinType kotlinType = (KotlinType)pair.component1();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)pair.component2();
            int n = valueParameterDescriptor.getIndex();
            Annotations annotations = valueParameterDescriptor.getAnnotations();
            Name name = valueParameterDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            boolean bl7 = valueParameterDescriptor.declaresDefaultValue();
            boolean bl8 = valueParameterDescriptor.isCrossinline();
            boolean bl9 = valueParameterDescriptor.isNoinline();
            KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType() != null ? DescriptorUtilsKt.getModule(callableDescriptor).getBuiltIns().getArrayElementType(kotlinType) : null;
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
            collection4.add(new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations, name, kotlinType, bl7, bl8, bl9, kotlinType2, sourceElement));
        }
        return (List)collection3;
    }

    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        MemberScope memberScope = classDescriptor3.getStaticScope();
        LazyJavaStaticClassScope lazyJavaStaticClassScope = memberScope instanceof LazyJavaStaticClassScope ? (LazyJavaStaticClassScope)memberScope : null;
        if (lazyJavaStaticClassScope == null) {
            lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(classDescriptor3);
        }
        return lazyJavaStaticClassScope;
    }
}

