/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.UtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassDeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.DeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticScope;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorFactory;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class LazyJavaStaticClassScope
extends LazyJavaStaticScope {
    private final JavaClass jClass;
    private final JavaClassDescriptor ownerDescriptor;

    public LazyJavaStaticClassScope(LazyJavaResolverContext lazyJavaResolverContext, JavaClass javaClass, JavaClassDescriptor javaClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaClassDescriptor, (String)"");
        super(lazyJavaResolverContext);
        this.jClass = javaClass;
        this.ownerDescriptor = javaClassDescriptor;
    }

    @Override
    protected JavaClassDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    protected ClassDeclaredMemberIndex computeMemberIndex() {
        return new ClassDeclaredMemberIndex(this.jClass, LazyJavaStaticClassScope$$Lambda$0.INSTANCE);
    }

    @Override
    protected Set<Name> computeFunctionNames(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Set set2 = set = CollectionsKt.toMutableSet((Iterable)((DeclaredMemberIndex)this.getDeclaredMemberIndex().invoke()).getMethodNames());
        boolean bl = false;
        LazyJavaStaticClassScope lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(this.getOwnerDescriptor());
        Set set3 = lazyJavaStaticClassScope != null ? lazyJavaStaticClassScope.getFunctionNames() : null;
        if (set3 == null) {
            set3 = SetsKt.emptySet();
        }
        set2.addAll(set3);
        if (this.jClass.isEnum()) {
            Object[] objectArray = new Name[]{StandardNames.ENUM_VALUE_OF, StandardNames.ENUM_VALUES};
            set2.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        set2.addAll((Collection)this.getC().getComponents().getSyntheticPartsProvider().getStaticFunctionNames(this.getOwnerDescriptor(), this.getC()));
        return set;
    }

    @Override
    protected Set<Name> computePropertyNames(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Set set2 = set = CollectionsKt.toMutableSet((Iterable)((DeclaredMemberIndex)this.getDeclaredMemberIndex().invoke()).getFieldNames());
        boolean bl = false;
        this.flatMapJavaStaticSupertypesScopes(this.getOwnerDescriptor(), set2, LazyJavaStaticClassScope$$Lambda$1.INSTANCE);
        if (this.jClass.isEnum()) {
            set2.add(StandardNames.ENUM_ENTRIES);
        }
        return set;
    }

    @Override
    protected Set<Name> computeClassNames(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        return SetsKt.emptySet();
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return null;
    }

    @Override
    protected void computeNonDeclaredFunctions(Collection<SimpleFunctionDescriptor> collection, Name name) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Set<SimpleFunctionDescriptor> set = this.getStaticFunctionsFromJavaSuperClasses(name, this.getOwnerDescriptor());
        Collection<SimpleFunctionDescriptor> collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)set, collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"");
        collection.addAll(collection2);
        if (this.jClass.isEnum()) {
            Name name2 = name;
            if (Intrinsics.areEqual((Object)name2, (Object)StandardNames.ENUM_VALUE_OF)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValueOfMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"");
                collection.add(simpleFunctionDescriptor);
            } else if (Intrinsics.areEqual((Object)name2, (Object)StandardNames.ENUM_VALUES)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValuesMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"");
                collection.add(simpleFunctionDescriptor);
            }
        }
    }

    @Override
    protected void computeImplicitlyDeclaredFunctions(Collection<SimpleFunctionDescriptor> collection, Name name) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        this.getC().getComponents().getSyntheticPartsProvider().generateStaticFunctions(this.getOwnerDescriptor(), name, collection, this.getC());
    }

    @Override
    protected void computeNonDeclaredProperties(Name name, Collection<PropertyDescriptor> collection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Name name2 = name;
        Set set = this.flatMapJavaStaticSupertypesScopes(this.getOwnerDescriptor(), new LinkedHashSet(), new LazyJavaStaticClassScope$$Lambda$2(name2));
        if (!collection.isEmpty()) {
            Collection<PropertyDescriptor> collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, set, collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"");
            bl = collection.addAll(collection2);
        } else {
            Object object;
            boolean bl2;
            Object object2;
            Object object3 = set;
            Collection<PropertyDescriptor> collection3 = collection;
            boolean bl3 = false;
            Object object4 = object3;
            Object object5 = new LinkedHashMap();
            boolean bl4 = false;
            Iterator<Object> iterator2 = object4.iterator();
            while (iterator2.hasNext()) {
                Object object6;
                Object object7 = iterator2.next();
                object2 = (PropertyDescriptor)object7;
                bl2 = false;
                object = this.getRealOriginal((PropertyDescriptor)object2);
                Map map = object5;
                boolean bl5 = false;
                Object v = map.get(object);
                if (v == null) {
                    boolean bl6 = false;
                    List list = new ArrayList();
                    map.put(object, list);
                    object6 = list;
                } else {
                    object6 = v;
                }
                List list = (List)object6;
                list.add(object7);
            }
            object3 = object5;
            bl3 = false;
            object4 = object3;
            object5 = new ArrayList();
            bl4 = false;
            for (Map.Entry entry : object4.entrySet()) {
                object2 = entry;
                bl2 = false;
                Collection<PropertyDescriptor> collection4 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)object2.getValue(), collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
                Intrinsics.checkNotNullExpressionValue(collection4, (String)"");
                object = collection4;
                CollectionsKt.addAll((Collection)object5, (Iterable)object);
            }
            bl = collection3.addAll((List)object5);
        }
        if (this.jClass.isEnum() && Intrinsics.areEqual((Object)name, (Object)StandardNames.ENUM_ENTRIES)) {
            kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(collection, DescriptorFactory.createEnumEntriesProperty(this.getOwnerDescriptor()));
        }
    }

    private final Set<SimpleFunctionDescriptor> getStaticFunctionsFromJavaSuperClasses(Name name, ClassDescriptor classDescriptor) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(classDescriptor);
        if (lazyJavaStaticClassScope == null) {
            return SetsKt.emptySet();
        }
        LazyJavaStaticClassScope lazyJavaStaticClassScope2 = lazyJavaStaticClassScope;
        return CollectionsKt.toSet((Iterable)lazyJavaStaticClassScope2.getContributedFunctions(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS));
    }

    private final <R> Set<R> flatMapJavaStaticSupertypesScopes(ClassDescriptor classDescriptor, Set<R> set, Function1<? super MemberScope, ? extends Collection<? extends R>> function1) {
        DFS.dfs(CollectionsKt.listOf((Object)classDescriptor), LazyJavaStaticClassScope$$Lambda$3.INSTANCE, new DFS.AbstractNodeHandler<ClassDescriptor, Unit>(classDescriptor, set, function1){
            final /* synthetic */ ClassDescriptor $root;
            final /* synthetic */ Set<R> $result;
            final /* synthetic */ Function1<MemberScope, Collection<R>> $onJavaStaticScope;
            {
                this.$root = classDescriptor;
                this.$result = set;
                this.$onJavaStaticScope = function1;
            }

            public boolean beforeChildren(ClassDescriptor classDescriptor) {
                Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
                if (classDescriptor == this.$root) {
                    return true;
                }
                MemberScope memberScope = classDescriptor.getStaticScope();
                Intrinsics.checkNotNullExpressionValue((Object)memberScope, (String)"");
                MemberScope memberScope2 = memberScope;
                if (memberScope2 instanceof LazyJavaStaticScope) {
                    this.$result.addAll((Collection)this.$onJavaStaticScope.invoke((Object)memberScope2));
                    return false;
                }
                return true;
            }

            public void result() {
            }
        });
        return set;
    }

    private final PropertyDescriptor getRealOriginal(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getKind().isReal()) {
            return propertyDescriptor;
        }
        Collection<? extends PropertyDescriptor> collection = propertyDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        Iterable iterable = collection;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)t;
            Collection collection3 = collection2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)propertyDescriptor2);
            collection3.add(this.getRealOriginal(propertyDescriptor2));
        }
        return (PropertyDescriptor)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)((List)collection2)));
    }

    private static final boolean computeMemberIndex$lambda$0(JavaMember javaMember) {
        Intrinsics.checkNotNullParameter((Object)javaMember, (String)"");
        return javaMember.isStatic();
    }

    private static final Collection computePropertyNames$lambda$3$lambda$2(MemberScope memberScope) {
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        return memberScope.getVariableNames();
    }

    private static final Collection computeNonDeclaredProperties$lambda$4(Name name, MemberScope memberScope) {
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        return memberScope.getContributedVariables(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
    }

    private static final ClassDescriptor flatMapJavaStaticSupertypesScopes$lambda$8$lambda$7(KotlinType kotlinType) {
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    private static final Iterable flatMapJavaStaticSupertypesScopes$lambda$8(ClassDescriptor classDescriptor) {
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        return SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)LazyJavaStaticClassScope$$Lambda$4.INSTANCE));
    }

    static /* synthetic */ boolean accessor$LazyJavaStaticClassScope$lambda0(JavaMember javaMember) {
        return LazyJavaStaticClassScope.computeMemberIndex$lambda$0(javaMember);
    }

    static /* synthetic */ Collection accessor$LazyJavaStaticClassScope$lambda1(MemberScope memberScope) {
        return LazyJavaStaticClassScope.computePropertyNames$lambda$3$lambda$2(memberScope);
    }

    static /* synthetic */ Collection accessor$LazyJavaStaticClassScope$lambda2(Name name, MemberScope memberScope) {
        return LazyJavaStaticClassScope.computeNonDeclaredProperties$lambda$4(name, memberScope);
    }

    static /* synthetic */ Iterable accessor$LazyJavaStaticClassScope$lambda3(ClassDescriptor classDescriptor) {
        return LazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes$lambda$8(classDescriptor);
    }

    static /* synthetic */ ClassDescriptor accessor$LazyJavaStaticClassScope$lambda4(KotlinType kotlinType) {
        return LazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes$lambda$8$lambda$7(kotlinType);
    }
}

