/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.NotNullTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class NotNullTypeParameterImpl
extends DelegatingSimpleType
implements NotNullTypeParameter {
    private final SimpleType delegate;

    public NotNullTypeParameterImpl(SimpleType simpleType) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        this.delegate = simpleType;
    }

    @Override
    protected SimpleType getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isTypeParameter() {
        return true;
    }

    @Override
    public KotlinType substitutionResult(KotlinType kotlinType) {
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        if (!TypeUtilsKt.isTypeParameter(unwrappedType) && !TypeUtils.isNullableType(unwrappedType)) {
            return unwrappedType;
        }
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof SimpleType) {
            kotlinType2 = this.prepareReplacement((SimpleType)unwrappedType);
        } else if (unwrappedType2 instanceof FlexibleType) {
            kotlinType2 = TypeWithEnhancementKt.wrapEnhancement(KotlinTypeFactory.flexibleType(this.prepareReplacement(((FlexibleType)unwrappedType).getLowerBound()), this.prepareReplacement(((FlexibleType)unwrappedType).getUpperBound())), TypeWithEnhancementKt.getEnhancement(unwrappedType));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kotlinType2;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    private final SimpleType prepareReplacement(SimpleType simpleType) {
        SimpleType simpleType2 = simpleType.makeNullableAsSpecified(false);
        if (!TypeUtilsKt.isTypeParameter(simpleType)) {
            return simpleType2;
        }
        return new NotNullTypeParameterImpl(simpleType2);
    }

    @Override
    public NotNullTypeParameterImpl replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return new NotNullTypeParameterImpl(this.getDelegate().replaceAttributes(typeAttributes));
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        return bl ? this.getDelegate().makeNullableAsSpecified(true) : (SimpleType)this;
    }

    @Override
    public NotNullTypeParameterImpl replaceDelegate(SimpleType simpleType) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        return new NotNullTypeParameterImpl(simpleType);
    }
}

