/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;
    private final AnnotationDeserializer annotationDeserializer;
    private JvmMetadataVersion jvmMetadataVersion;

    public BinaryClassAnnotationAndConstantLoaderImpl(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses, StorageManager storageManager, KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        super(storageManager, kotlinClassFinder);
        this.module = moduleDescriptor;
        this.notFoundClasses = notFoundClasses;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
        this.jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
    }

    @Override
    public JvmMetadataVersion getJvmMetadataVersion() {
        return this.jvmMetadataVersion;
    }

    public void setJvmMetadataVersion(JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        this.jvmMetadataVersion = jvmMetadataVersion;
    }

    @Override
    public AnnotationDescriptor loadAnnotation(ProtoBuf.Annotation annotation, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        return this.annotationDeserializer.deserializeAnnotation(annotation, nameResolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ConstantValue<?> loadConstant(String string, Object object) {
        Object object2;
        block11: {
            block8: {
                int n;
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        Intrinsics.checkNotNullParameter((Object)object, (String)"");
                        if (!StringsKt.contains$default((CharSequence)"ZBCS", (CharSequence)string, (boolean)false, (int)2, null)) break block8;
                        n = (Integer)object;
                        String string2 = string;
                        switch (string2.hashCode()) {
                            case 66: {
                                if (string2.equals("B")) break;
                                throw new AssertionError((Object)string);
                            }
                            case 67: {
                                if (!string2.equals("C")) {
                                    throw new AssertionError((Object)string);
                                }
                                break block9;
                            }
                            case 83: {
                                if (!string2.equals("S")) {
                                    throw new AssertionError((Object)string);
                                }
                                break block10;
                            }
                            case 90: {
                                if (!string2.equals("Z")) throw new AssertionError((Object)string);
                                object2 = n != 0;
                                break block11;
                            }
                        }
                        object2 = (byte)n;
                        break block11;
                    }
                    object2 = Character.valueOf((char)n);
                    break block11;
                }
                object2 = (short)n;
                break block11;
                throw new AssertionError((Object)string);
            }
            object2 = object;
        }
        Object object3 = object2;
        return ConstantValueFactory.INSTANCE.createConstantValue(object3, this.module);
    }

    @Override
    protected ConstantValue<?> transformToUnsignedConstant(ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"");
        ConstantValue constantValue2 = constantValue;
        return constantValue2 instanceof ByteValue ? (ConstantValue)new UByteValue(((Number)((ByteValue)constantValue).getValue()).byteValue()) : (constantValue2 instanceof ShortValue ? (ConstantValue)new UShortValue(((Number)((ShortValue)constantValue).getValue()).shortValue()) : (constantValue2 instanceof IntValue ? (ConstantValue)new UIntValue(((Number)((IntValue)constantValue).getValue()).intValue()) : (constantValue2 instanceof LongValue ? (ConstantValue)new ULongValue(((Number)((LongValue)constantValue).getValue()).longValue()) : constantValue)));
    }

    @Override
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(ClassId classId, SourceElement sourceElement, List<AnnotationDescriptor> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        ClassDescriptor classDescriptor = this.resolveClass(classId);
        return new AbstractAnnotationArgumentVisitor(this, classDescriptor, classId, list, sourceElement){
            private final HashMap<Name, ConstantValue<?>> arguments;
            final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
            final /* synthetic */ ClassDescriptor $annotationClass;
            final /* synthetic */ ClassId $annotationClassId;
            final /* synthetic */ List<AnnotationDescriptor> $result;
            final /* synthetic */ SourceElement $source;
            {
                this.this$0 = binaryClassAnnotationAndConstantLoaderImpl;
                this.$annotationClass = classDescriptor;
                this.$annotationClassId = classId;
                this.$result = list;
                this.$source = sourceElement;
                this.arguments = new HashMap<K, V>();
            }

            public void visitConstantValue(Name name, ConstantValue<?> constantValue) {
                Intrinsics.checkNotNullParameter(constantValue, (String)"");
                if (name != null) {
                    ((Map)this.arguments).put(name, constantValue);
                }
            }

            public void visitArrayValue(Name name, ArrayList<ConstantValue<?>> arrayList) {
                Intrinsics.checkNotNullParameter(arrayList, (String)"");
                if (name == null) {
                    return;
                }
                ValueParameterDescriptor valueParameterDescriptor = DescriptorResolverUtils.getAnnotationParameterByName(name, this.$annotationClass);
                if (valueParameterDescriptor != null) {
                    Map map = this.arguments;
                    List<ConstantValue<?>> list = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.compact(arrayList);
                    KotlinType kotlinType = valueParameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                    ArrayValue arrayValue = ConstantValueFactory.INSTANCE.createArrayValue(list, kotlinType);
                    map.put(name, arrayValue);
                } else if (this.this$0.isImplicitRepeatableContainer(this.$annotationClassId) && Intrinsics.areEqual((Object)name.asString(), (Object)"value")) {
                    Iterable iterable = arrayList;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    Collection collection = new ArrayList<E>();
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        if (!(t instanceof AnnotationValue)) continue;
                        collection.add(t);
                    }
                    iterable = (List)collection;
                    Collection collection2 = this.$result;
                    boolean bl3 = false;
                    for (E e : iterable) {
                        AnnotationValue annotationValue = (AnnotationValue)e;
                        Collection collection3 = collection2;
                        boolean bl4 = false;
                        collection3.add((AnnotationDescriptor)annotationValue.getValue());
                    }
                }
            }

            public void visitEnd() {
                if (this.this$0.isRepeatableWithImplicitContainer(this.$annotationClassId, (Map)this.arguments)) {
                    return;
                }
                if (this.this$0.isImplicitRepeatableContainer(this.$annotationClassId)) {
                    return;
                }
                this.$result.add(new AnnotationDescriptorImpl(this.$annotationClass.getDefaultType(), (Map)this.arguments, this.$source));
            }
        };
    }

    private final ConstantValue<?> createConstant(Name name, Object object) {
        ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(object, this.module);
        if (constantValue == null) {
            constantValue = ErrorValue.Companion.create("Unsupported annotation argument: " + name);
        }
        return constantValue;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    private abstract class AbstractAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        public abstract void visitConstantValue(Name var1, ConstantValue<?> var2);

        public abstract void visitArrayValue(Name var1, ArrayList<ConstantValue<?>> var2);

        @Override
        public void visit(Name name, Object object) {
            this.visitConstantValue(name, BinaryClassAnnotationAndConstantLoaderImpl.this.createConstant(name, object));
        }

        @Override
        public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
            Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
            this.visitConstantValue(name, new KClassValue(classLiteralValue));
        }

        @Override
        public void visitEnum(Name name, ClassId classId, Name name2) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"");
            this.visitConstantValue(name, new EnumValue(classId, name2));
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
            return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(BinaryClassAnnotationAndConstantLoaderImpl.this, name, this){
                private final ArrayList<ConstantValue<?>> elements;
                final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ AbstractAnnotationArgumentVisitor this$1;
                {
                    this.this$0 = binaryClassAnnotationAndConstantLoaderImpl;
                    this.$name = name;
                    this.this$1 = abstractAnnotationArgumentVisitor;
                    this.elements = new ArrayList<E>();
                }

                public void visit(Object object) {
                    this.elements.add(BinaryClassAnnotationAndConstantLoaderImpl.access$createConstant(this.this$0, this.$name, object));
                }

                public void visitEnum(ClassId classId, Name name) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                    Intrinsics.checkNotNullParameter((Object)name, (String)"");
                    this.elements.add(new EnumValue(classId, name));
                }

                public void visitClassLiteral(ClassLiteralValue classLiteralValue) {
                    Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
                    this.elements.add(new KClassValue(classLiteralValue));
                }

                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                    ArrayList<AnnotationDescriptor> arrayList = new ArrayList<AnnotationDescriptor>();
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)arrayList);
                    Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                    return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(annotationArgumentVisitor2, this, arrayList){
                        private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                        final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                        final /* synthetic */ visitArray.1 this$0;
                        final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                        {
                            this.$visitor = annotationArgumentVisitor;
                            this.this$0 = var2_2;
                            this.$list = arrayList;
                            this.$$delegate_0 = annotationArgumentVisitor;
                        }

                        public void visitEnd() {
                            this.$visitor.visitEnd();
                            visitArray.1.access$getElements$p(this.this$0).add(new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                        }

                        public void visit(Name name, Object object) {
                            this.$$delegate_0.visit(name, object);
                        }

                        public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
                            Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
                            this.$$delegate_0.visitClassLiteral(name, classLiteralValue);
                        }

                        public void visitEnum(Name name, ClassId classId, Name name2) {
                            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                            Intrinsics.checkNotNullParameter((Object)name2, (String)"");
                            this.$$delegate_0.visitEnum(name, classId, name2);
                        }

                        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
                            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                            return this.$$delegate_0.visitAnnotation(name, classId);
                        }

                        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
                            return this.$$delegate_0.visitArray(name);
                        }
                    };
                }

                public void visitEnd() {
                    this.this$1.visitArrayValue(this.$name, this.elements);
                }

                public static final /* synthetic */ ArrayList access$getElements$p(visitArray.1 var0) {
                    return var0.elements;
                }
            };
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            ArrayList<AnnotationDescriptor> arrayList = new ArrayList<AnnotationDescriptor>();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = BinaryClassAnnotationAndConstantLoaderImpl.this.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)arrayList);
            Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(annotationArgumentVisitor2, this, name, arrayList){
                private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                final /* synthetic */ AbstractAnnotationArgumentVisitor this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                {
                    this.$visitor = annotationArgumentVisitor;
                    this.this$0 = abstractAnnotationArgumentVisitor;
                    this.$name = name;
                    this.$list = arrayList;
                    this.$$delegate_0 = annotationArgumentVisitor;
                }

                public void visitEnd() {
                    this.$visitor.visitEnd();
                    this.this$0.visitConstantValue(this.$name, new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                }

                public void visit(Name name, Object object) {
                    this.$$delegate_0.visit(name, object);
                }

                public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
                    Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
                    this.$$delegate_0.visitClassLiteral(name, classLiteralValue);
                }

                public void visitEnum(Name name, ClassId classId, Name name2) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"");
                    this.$$delegate_0.visitEnum(name, classId, name2);
                }

                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                    return this.$$delegate_0.visitAnnotation(name, classId);
                }

                public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
                    return this.$$delegate_0.visitArray(name);
                }
            };
        }
    }
}

