/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;

public final class DescriptorBasedTypeSignatureMappingKt {
    public static final <T> T mapType(KotlinType kotlinType, JvmTypeFactory<T> jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration<? extends T> typeMappingConfiguration, JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter, Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> function3) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeMappingMode, (String)"");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"");
        Intrinsics.checkNotNullParameter(function3, (String)"");
        Object object = typeMappingConfiguration.preprocessType(kotlinType);
        if (object != null) {
            KotlinType kotlinType2 = object;
            boolean bl = false;
            return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType2, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType), jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
        }
        Object object2 = SimpleClassicTypeSystemContext.INSTANCE;
        boolean bl = false;
        object = TypeSignatureMappingKt.mapBuiltInType((TypeSystemCommonBackendContext)object2, kotlinType, jvmTypeFactory, typeMappingMode);
        if (object != null) {
            object2 = object;
            bl = false;
            Object object3 = TypeSignatureMappingKt.boxTypeIfNeeded(jvmTypeFactory, object2, typeMappingMode.getNeedPrimitiveBoxing());
            function3.invoke((Object)kotlinType, object3, (Object)typeMappingMode);
            return (T)object3;
        }
        object = kotlinType.getConstructor();
        if (object instanceof IntersectionTypeConstructor) {
            KotlinType kotlinType3 = ((IntersectionTypeConstructor)object).getAlternativeType();
            if (kotlinType3 == null) {
                kotlinType3 = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)object).getSupertypes());
            }
            KotlinType kotlinType4 = kotlinType3;
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType4), jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
        }
        ClassifierDescriptor classifierDescriptor = object.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(classifierDescriptor2)) {
            object2 = jvmTypeFactory.createObjectType("error/NonExistentClass");
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
            if (jvmDescriptorTypeWriter2 != null) {
                jvmDescriptorTypeWriter2.writeClass(object2);
            }
            return (T)object2;
        }
        if (classifierDescriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            object2 = kotlinType.getArguments().get(0);
            KotlinType kotlinType5 = object2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType5, (String)"");
            KotlinType kotlinType6 = kotlinType5;
            Object t = null;
            if (object2.getProjectionKind() == Variance.IN_VARIANCE) {
                t = jvmTypeFactory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = jvmDescriptorTypeWriter;
                if (jvmDescriptorTypeWriter3 != null) {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4;
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter5 = jvmDescriptorTypeWriter4 = jvmDescriptorTypeWriter3;
                    boolean bl2 = false;
                    jvmDescriptorTypeWriter5.writeArrayType();
                    jvmDescriptorTypeWriter5.writeClass(t);
                    jvmDescriptorTypeWriter5.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter6 = jvmDescriptorTypeWriter;
                if (jvmDescriptorTypeWriter6 != null) {
                    jvmDescriptorTypeWriter6.writeArrayType();
                }
                Variance variance = object2.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                t = DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType6, jvmTypeFactory, typeMappingMode.toGenericArgumentMode(variance, true), typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter7 = jvmDescriptorTypeWriter;
                if (jvmDescriptorTypeWriter7 != null) {
                    jvmDescriptorTypeWriter7.writeArrayEnd();
                }
            }
            return jvmTypeFactory.createFromString('[' + jvmTypeFactory.toString(t));
        }
        if (classifierDescriptor2 instanceof ClassDescriptor) {
            T t;
            if (InlineClassesUtilsKt.isInlineClass(classifierDescriptor2) && !typeMappingMode.getNeedInlineClassWrapping() && (object2 = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, kotlinType)) != null) {
                return DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object2, jvmTypeFactory, typeMappingMode.wrapInlineClassesMode(), typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
            }
            if (typeMappingMode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)classifierDescriptor2)) {
                t = jvmTypeFactory.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)classifierDescriptor2).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
                t = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t == null) {
                    ClassDescriptor classDescriptor2;
                    boolean bl3 = false;
                    if (((ClassDescriptor)classifierDescriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)classifierDescriptor2).getContainingDeclaration();
                        Intrinsics.checkNotNull((Object)declarationDescriptor);
                        classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor2 = (ClassDescriptor)classifierDescriptor2;
                    }
                    ClassDescriptor classDescriptor3 = classDescriptor2;
                    ClassDescriptor classDescriptor4 = classDescriptor3.getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor4, (String)"");
                    t = jvmTypeFactory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor4, typeMappingConfiguration));
                }
            }
            object2 = t;
            function3.invoke((Object)kotlinType, object2, (Object)typeMappingMode);
            return (T)object2;
        }
        if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            object2 = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)classifierDescriptor2);
            Object object4 = kotlinType.isMarkedNullable() ? TypeUtilsKt.makeNullable((KotlinType)object2) : object2;
            Function3<Object, Object, Object, Unit> function32 = FunctionsKt.getDO_NOTHING_3();
            Object object5 = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object4, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, null, function32);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter8 = jvmDescriptorTypeWriter;
            if (jvmDescriptorTypeWriter8 != null) {
                Name name = classifierDescriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                jvmDescriptorTypeWriter8.writeTypeVariable(name, object5);
            }
            return (T)object5;
        }
        if (classifierDescriptor2 instanceof TypeAliasDescriptor && typeMappingMode.getMapTypeAliases()) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)classifierDescriptor2).getExpandedType(), jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
        }
        throw new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        if (callableDescriptor instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = callableDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = callableDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (callableDescriptor instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    public static final String computeInternalName(ClassDescriptor classDescriptor, TypeMappingConfiguration<?> typeMappingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"");
        Object object = typeMappingConfiguration.getPredefinedFullInternalNameForClass(classDescriptor);
        if (object != null) {
            String string = object;
            boolean bl = false;
            return string;
        }
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        object = declarationDescriptor;
        String string = SpecialNames.safeIdentifier(classDescriptor.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        if (object instanceof PackageFragmentDescriptor) {
            FqName fqName = ((PackageFragmentDescriptor)object).getFqName();
            return fqName.isRoot() ? string2 : StringsKt.replace$default((String)fqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + string2;
        }
        ClassDescriptor classDescriptor2 = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (classDescriptor2 == null) {
            throw new IllegalArgumentException("Unexpected container: " + object + " for " + classDescriptor);
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        String string3 = typeMappingConfiguration.getPredefinedInternalNameForClass(classDescriptor3);
        if (string3 == null) {
            string3 = DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration);
        }
        String string4 = string3;
        return string4 + '$' + string2;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

