/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents$$Lambda$0;

public final class SignatureBuildingComponents {
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    public final String javaLang(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/lang/" + string;
    }

    public final String javaUtil(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/util/" + string;
    }

    public final String javaFunction(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "java/util/function/" + string;
    }

    public final String[] constructors(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Object object = stringArray;
        boolean bl = false;
        String[] stringArray2 = object;
        Collection collection = new ArrayList(((String[])object).length);
        boolean bl2 = false;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray2[i];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add("<init>(" + string2 + ")V");
        }
        object = (List)collection;
        bl = false;
        stringArray2 = object;
        return stringArray2.toArray(new String[0]);
    }

    public final Set<String> inJavaLang(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.inClass(this.javaLang(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set<String> inJavaUtil(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.inClass(this.javaUtil(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final Set<String> inClass(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        String[] stringArray2 = stringArray;
        Collection collection = new LinkedHashSet();
        boolean bl = false;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = string2 = stringArray2[i];
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(string + '.' + string3);
        }
        return (Set)collection;
    }

    public final String signature(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return string + '.' + string2;
    }

    public final String jvmDescriptor(String string, List<String> list, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return string + '(' + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)SignatureBuildingComponents$$Lambda$0.INSTANCE, (int)30, null) + ')' + this.escapeClassName(string2);
    }

    private final String escapeClassName(String string) {
        return string.length() > 1 ? 'L' + string + ';' : string;
    }

    private static final CharSequence jvmDescriptor$lambda$2(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return INSTANCE.escapeClassName(string);
    }

    static /* synthetic */ CharSequence accessor$SignatureBuildingComponents$lambda0(String string) {
        return SignatureBuildingComponents.jvmDescriptor$lambda$2(string);
    }
}

