/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;

public final class NameResolverImpl
implements NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(ProtoBuf.StringTable stringTable, ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)qualifiedNameTable, (String)"");
        this.strings = stringTable;
        this.qualifiedNames = qualifiedNameTable;
    }

    @Override
    public String getString(int n) {
        String string = this.strings.getString(n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String getQualifiedClassName(int n) {
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(n);
        List list = (List)triple.component1();
        List list2 = (List)triple.component2();
        String string = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return list.isEmpty() ? string : CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + string;
    }

    @Override
    public boolean isLocalClassName(int n) {
        return (Boolean)this.traverseIds(n).getThird();
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int n) {
        int n2 = n;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        boolean bl = false;
        while (n2 != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(n2);
            String string = this.strings.getString(qualifiedName.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = qualifiedName.getKind();
            Intrinsics.checkNotNull((Object)kind);
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    linkedList2.addFirst(string);
                    break;
                }
                case 2: {
                    linkedList.addFirst(string);
                    break;
                }
                case 3: {
                    linkedList2.addFirst(string);
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            n2 = qualifiedName.getParentQualifiedName();
        }
        return new Triple(linkedList, linkedList2, (Object)bl);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

