/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;

public final class ProtoTypeTableUtilKt {
    public static final List<ProtoBuf.Type> supertypes(ProtoBuf.Class clazz, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = clazz.getSupertypeList();
        Collection collection = (Collection)iterable;
        boolean bl = false;
        Iterable<Object> iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = clazz.getSupertypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl2 = false;
            Iterable<ProtoBuf.Type> iterable3 = iterable;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean bl3 = false;
            for (ProtoBuf.Type type : iterable3) {
                Integer n = (Integer)((Object)type);
                Collection collection3 = collection2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)n);
                collection3.add(typeTable.get(n));
            }
            iterable2 = (List)collection2;
        }
        return iterable2;
    }

    public static final ProtoBuf.Type inlineClassUnderlyingType(ProtoBuf.Class clazz, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return clazz.hasInlineClassUnderlyingType() ? clazz.getInlineClassUnderlyingType() : (clazz.hasInlineClassUnderlyingTypeId() ? typeTable.get(clazz.getInlineClassUnderlyingTypeId()) : null);
    }

    public static final ProtoBuf.Type type(ProtoBuf.Type.Argument argument, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return argument.hasType() ? argument.getType() : (argument.hasTypeId() ? typeTable.get(argument.getTypeId()) : null);
    }

    public static final ProtoBuf.Type flexibleUpperBound(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return type.hasFlexibleUpperBound() ? type.getFlexibleUpperBound() : (type.hasFlexibleUpperBoundId() ? typeTable.get(type.getFlexibleUpperBoundId()) : null);
    }

    public static final List<ProtoBuf.Type> upperBounds(ProtoBuf.TypeParameter typeParameter, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = typeParameter.getUpperBoundList();
        Collection collection = (Collection)iterable;
        boolean bl = false;
        Iterable<Object> iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = typeParameter.getUpperBoundIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl2 = false;
            Iterable<ProtoBuf.Type> iterable3 = iterable;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean bl3 = false;
            for (ProtoBuf.Type type : iterable3) {
                Integer n = (Integer)((Object)type);
                Collection collection3 = collection2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)n);
                collection3.add(typeTable.get(n));
            }
            iterable2 = (List)collection2;
        }
        return iterable2;
    }

    public static final ProtoBuf.Type returnType(ProtoBuf.Function function, TypeTable typeTable) {
        ProtoBuf.Type type;
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (function.hasReturnType()) {
            ProtoBuf.Type type2 = function.getReturnType();
            type = type2;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        } else if (function.hasReturnTypeId()) {
            type = typeTable.get(function.getReturnTypeId());
        } else {
            throw new IllegalStateException("No returnType in ProtoBuf.Function".toString());
        }
        return type;
    }

    public static final boolean hasReceiver(ProtoBuf.Function function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        return function.hasReceiverType() || function.hasReceiverTypeId();
    }

    public static final ProtoBuf.Type receiverType(ProtoBuf.Function function, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return function.hasReceiverType() ? function.getReceiverType() : (function.hasReceiverTypeId() ? typeTable.get(function.getReceiverTypeId()) : null);
    }

    public static final ProtoBuf.Type returnType(ProtoBuf.Property property, TypeTable typeTable) {
        ProtoBuf.Type type;
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (property.hasReturnType()) {
            ProtoBuf.Type type2 = property.getReturnType();
            type = type2;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        } else if (property.hasReturnTypeId()) {
            type = typeTable.get(property.getReturnTypeId());
        } else {
            throw new IllegalStateException("No returnType in ProtoBuf.Property".toString());
        }
        return type;
    }

    public static final boolean hasReceiver(ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return property.hasReceiverType() || property.hasReceiverTypeId();
    }

    public static final ProtoBuf.Type receiverType(ProtoBuf.Property property, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return property.hasReceiverType() ? property.getReceiverType() : (property.hasReceiverTypeId() ? typeTable.get(property.getReceiverTypeId()) : null);
    }

    public static final ProtoBuf.Type type(ProtoBuf.ValueParameter valueParameter, TypeTable typeTable) {
        ProtoBuf.Type type;
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (valueParameter.hasType()) {
            ProtoBuf.Type type2 = valueParameter.getType();
            type = type2;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        } else if (valueParameter.hasTypeId()) {
            type = typeTable.get(valueParameter.getTypeId());
        } else {
            throw new IllegalStateException("No type in ProtoBuf.ValueParameter".toString());
        }
        return type;
    }

    public static final ProtoBuf.Type varargElementType(ProtoBuf.ValueParameter valueParameter, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return valueParameter.hasVarargElementType() ? valueParameter.getVarargElementType() : (valueParameter.hasVarargElementTypeId() ? typeTable.get(valueParameter.getVarargElementTypeId()) : null);
    }

    public static final ProtoBuf.Type outerType(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return type.hasOuterType() ? type.getOuterType() : (type.hasOuterTypeId() ? typeTable.get(type.getOuterTypeId()) : null);
    }

    public static final ProtoBuf.Type abbreviatedType(ProtoBuf.Type type, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        return type.hasAbbreviatedType() ? type.getAbbreviatedType() : (type.hasAbbreviatedTypeId() ? typeTable.get(type.getAbbreviatedTypeId()) : null);
    }

    public static final ProtoBuf.Type underlyingType(ProtoBuf.TypeAlias typeAlias, TypeTable typeTable) {
        ProtoBuf.Type type;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (typeAlias.hasUnderlyingType()) {
            ProtoBuf.Type type2 = typeAlias.getUnderlyingType();
            type = type2;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        } else if (typeAlias.hasUnderlyingTypeId()) {
            type = typeTable.get(typeAlias.getUnderlyingTypeId());
        } else {
            throw new IllegalStateException("No underlyingType in ProtoBuf.TypeAlias".toString());
        }
        return type;
    }

    public static final ProtoBuf.Type expandedType(ProtoBuf.TypeAlias typeAlias, TypeTable typeTable) {
        ProtoBuf.Type type;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        if (typeAlias.hasExpandedType()) {
            ProtoBuf.Type type2 = typeAlias.getExpandedType();
            type = type2;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"");
        } else if (typeAlias.hasExpandedTypeId()) {
            type = typeTable.get(typeAlias.getExpandedTypeId());
        } else {
            throw new IllegalStateException("No expandedType in ProtoBuf.TypeAlias".toString());
        }
        return type;
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Class clazz, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = clazz.getContextReceiverTypeList();
        Collection collection = (Collection)iterable;
        boolean bl = false;
        Iterable<Object> iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = clazz.getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl2 = false;
            Iterable<ProtoBuf.Type> iterable3 = iterable;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean bl3 = false;
            for (ProtoBuf.Type type : iterable3) {
                Integer n = (Integer)((Object)type);
                Collection collection3 = collection2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)n);
                collection3.add(typeTable.get(n));
            }
            iterable2 = (List)collection2;
        }
        return iterable2;
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Function function, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = function.getContextReceiverTypeList();
        Collection collection = (Collection)iterable;
        boolean bl = false;
        Iterable<Object> iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = function.getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl2 = false;
            Iterable<ProtoBuf.Type> iterable3 = iterable;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean bl3 = false;
            for (ProtoBuf.Type type : iterable3) {
                Integer n = (Integer)((Object)type);
                Collection collection3 = collection2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)n);
                collection3.add(typeTable.get(n));
            }
            iterable2 = (List)collection2;
        }
        return iterable2;
    }

    public static final List<ProtoBuf.Type> contextReceiverTypes(ProtoBuf.Property property, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Iterable<ProtoBuf.Type> iterable = property.getContextReceiverTypeList();
        Collection collection = (Collection)iterable;
        boolean bl = false;
        Iterable<Object> iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 == null) {
            List<Integer> list = property.getContextReceiverTypeIdList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable = list;
            boolean bl2 = false;
            Iterable<ProtoBuf.Type> iterable3 = iterable;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean bl3 = false;
            for (ProtoBuf.Type type : iterable3) {
                Integer n = (Integer)((Object)type);
                Collection collection3 = collection2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)n);
                collection3.add(typeTable.get(n));
            }
            iterable2 = (List)collection2;
        }
        return iterable2;
    }
}

