/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;

public interface ClassifierNamePolicy {
    public String renderClassifier(ClassifierDescriptor var1, DescriptorRenderer var2);

    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        public static final FULLY_QUALIFIED INSTANCE = new FULLY_QUALIFIED();

        private FULLY_QUALIFIED() {
        }

        @Override
        public String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer) {
            Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifierDescriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                return descriptorRenderer.renderName(name, false);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classifierDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
            return descriptorRenderer.renderFqName(fqNameUnsafe);
        }
    }

    public static final class SHORT
    implements ClassifierNamePolicy {
        public static final SHORT INSTANCE = new SHORT();

        private SHORT() {
        }

        @Override
        public String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer) {
            Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifierDescriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                return descriptorRenderer.renderName(name, false);
            }
            ArrayList<Name> arrayList = new ArrayList<Name>();
            DeclarationDescriptor declarationDescriptor = classifierDescriptor;
            do {
                arrayList.add(declarationDescriptor.getName());
            } while ((declarationDescriptor = declarationDescriptor.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)arrayList));
        }
    }

    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        public static final SOURCE_CODE_QUALIFIED INSTANCE = new SOURCE_CODE_QUALIFIED();

        private SOURCE_CODE_QUALIFIED() {
        }

        @Override
        public String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer) {
            Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
            return this.qualifiedNameForSourceCode(classifierDescriptor);
        }

        private final String qualifiedNameForSourceCode(ClassifierDescriptor classifierDescriptor) {
            Name name = classifierDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            String string = RenderingUtilsKt.render(name);
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                return string;
            }
            DeclarationDescriptor declarationDescriptor = classifierDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
            String string2 = this.qualifierName(declarationDescriptor);
            return string2 != null && !Intrinsics.areEqual((Object)string2, (Object)"") ? string2 + '.' + string : string;
        }

        private final String qualifierName(DeclarationDescriptor declarationDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            return declarationDescriptor2 instanceof ClassDescriptor ? this.qualifiedNameForSourceCode((ClassifierDescriptor)declarationDescriptor) : (declarationDescriptor2 instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)declarationDescriptor).getFqName().toUnsafe()) : null);
        }
    }
}

