/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class EnumValue
extends ConstantValue<Pair<? extends ClassId, ? extends Name>> {
    private final ClassId enumClassId;
    private final Name enumEntryName;

    public EnumValue(ClassId classId, Name name) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        super(TuplesKt.to((Object)classId, (Object)name));
        this.enumClassId = classId;
        this.enumEntryName = name;
    }

    public final Name getEnumEntryName() {
        return this.enumEntryName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public KotlinType getType(ModuleDescriptor moduleDescriptor) {
        KotlinType kotlinType;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, this.enumClassId);
        if (annotated != null) {
            ClassDescriptor classDescriptor = annotated;
            stringArray = (String[])classDescriptor;
            boolean bl = false;
            annotated = DescriptorUtils.isEnumClass((DeclarationDescriptor)stringArray) ? classDescriptor : null;
            if (annotated != null && (annotated = annotated.getDefaultType()) != null) {
                kotlinType = (KotlinType)annotated;
                return kotlinType;
            }
        }
        stringArray = new String[]{this.enumClassId.toString(), this.enumEntryName.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_ENUM_TYPE, stringArray);
        return kotlinType;
    }

    @Override
    public String toString() {
        return "" + this.enumClassId.getShortClassName() + '.' + this.enumEntryName;
    }
}

