/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;

public final class JavaDescriptorResolver {
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    private final JavaResolverCache javaResolverCache;

    public JavaDescriptorResolver(LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider, JavaResolverCache javaResolverCache) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaPackageFragmentProvider, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaResolverCache, (String)"");
        this.packageFragmentProvider = lazyJavaPackageFragmentProvider;
        this.javaResolverCache = javaResolverCache;
    }

    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    public final ClassDescriptor resolveClass(JavaClass javaClass) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        FqName fqName = javaClass.getFqName();
        if (fqName != null && javaClass.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return this.javaResolverCache.getClassResolvedFromSource(fqName);
        }
        JavaClass javaClass2 = javaClass.getOuterClass();
        if (javaClass2 != null) {
            MemberScope memberScope;
            JavaClass javaClass3 = javaClass2;
            boolean bl = false;
            ClassDescriptor classDescriptor = this.resolveClass(javaClass3);
            MemberScope memberScope2 = memberScope = classDescriptor != null ? classDescriptor.getUnsubstitutedInnerClassesScope() : null;
            ClassifierDescriptor classifierDescriptor = memberScope2 != null ? memberScope2.getContributedClassifier(javaClass.getName(), NoLookupLocation.FROM_JAVA_LOADER) : null;
            return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        }
        if (fqName == null) {
            return null;
        }
        LazyJavaPackageFragment lazyJavaPackageFragment = (LazyJavaPackageFragment)CollectionsKt.firstOrNull(this.packageFragmentProvider.getPackageFragments(fqName.parent()));
        return lazyJavaPackageFragment != null ? lazyJavaPackageFragment.findClassifierByJavaClass$descriptors_jvm(javaClass) : null;
    }
}

