/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.ClassDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDeserializer$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;

public final class ClassDeserializer {
    public static final Companion Companion = new Companion(null);
    private final DeserializationComponents components;
    private final Function1<ClassKey, ClassDescriptor> classes;
    private static final Set<ClassId> BLACK_LIST = SetsKt.setOf((Object)ClassId.Companion.topLevel(StandardNames.FqNames.cloneable.toSafe()));

    public ClassDeserializer(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        this.components = deserializationComponents;
        ClassDeserializer classDeserializer = this;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues(new ClassDeserializer$$Lambda$0(classDeserializer));
    }

    public final ClassDescriptor deserializeClass(ClassId classId, ClassData classData) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    private final ClassDescriptor createClass(ClassKey classKey) {
        DeserializationContext deserializationContext;
        Object object;
        Object object2;
        ClassId classId = classKey.getClassId();
        for (ClassDescriptorFactory object32 : this.components.getFictitiousClassDescriptorFactories()) {
            object2 = object32.createClass(classId);
            if (object2 == null) continue;
            ClassDescriptor sourceElement = object2;
            boolean classId2 = false;
            return sourceElement;
        }
        if (BLACK_LIST.contains(classId)) {
            return null;
        }
        ClassData classData = classKey.getClassData();
        if (classData == null && (classData = this.components.getClassDataFinder().findClassData(classId)) == null) {
            return null;
        }
        ClassData classData2 = classData;
        NameResolver nameResolver = classData2.component1();
        object2 = classData2.component2();
        BinaryVersion binaryVersion = classData2.component3();
        SourceElement sourceElement = classData2.component4();
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 != null) {
            ClassDescriptor classDescriptor = ClassDeserializer.deserializeClass$default(this, classId2, null, 2, null);
            DeserializedClassDescriptor deserializedClassDescriptor = classDescriptor instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)classDescriptor : null;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            object = deserializedClassDescriptor;
            if (!((DeserializedClassDescriptor)object).hasNestedClass$deserialization(classId.getShortClassName())) {
                return null;
            }
            deserializationContext = ((DeserializedClassDescriptor)object).getC();
        } else {
            Object v3;
            block9: {
                object = PackageFragmentProviderKt.packageFragments(this.components.getPackageFragmentProvider(), classId.getPackageFqName());
                Iterable iterable = (Iterable)object;
                boolean bl = false;
                for (Object t : iterable) {
                    PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)t;
                    boolean bl2 = false;
                    if (!(!(packageFragmentDescriptor instanceof DeserializedPackageFragment) || ((DeserializedPackageFragment)packageFragmentDescriptor).hasTopLevelClass(classId.getShortClassName()))) continue;
                    v3 = t;
                    break block9;
                }
                v3 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = v3;
            if (packageFragmentDescriptor == null) {
                return null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor;
            ProtoBuf.TypeTable typeTable = ((ProtoBuf.Class)object2).getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"");
            TypeTable typeTable2 = new TypeTable(typeTable);
            ProtoBuf.VersionRequirementTable versionRequirementTable = ((ProtoBuf.Class)object2).getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue((Object)versionRequirementTable, (String)"");
            deserializationContext = this.components.createContext(packageFragmentDescriptor2, nameResolver, typeTable2, VersionRequirementTable.Companion.create(versionRequirementTable), binaryVersion, null);
        }
        DeserializationContext deserializationContext2 = deserializationContext;
        return new DeserializedClassDescriptor(deserializationContext2, (ProtoBuf.Class)object2, nameResolver, binaryVersion, sourceElement);
    }

    private static final ClassDescriptor classes$lambda$0(ClassDeserializer classDeserializer, ClassKey classKey) {
        Intrinsics.checkNotNullParameter((Object)classKey, (String)"");
        return classDeserializer.createClass(classKey);
    }

    static /* synthetic */ ClassDescriptor accessor$ClassDeserializer$lambda0(ClassDeserializer classDeserializer, ClassKey classKey) {
        return ClassDeserializer.classes$lambda$0(classDeserializer, classKey);
    }

    private static final class ClassKey {
        private final ClassId classId;
        private final ClassData classData;

        public ClassKey(ClassId classId, ClassData classData) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            this.classId = classId;
            this.classData = classData;
        }

        public final ClassId getClassId() {
            return this.classId;
        }

        public final ClassData getClassData() {
            return this.classData;
        }

        public boolean equals(Object object) {
            return object instanceof ClassKey && Intrinsics.areEqual((Object)this.classId, (Object)((ClassKey)object).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

